package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.TrainingJobName
import scala.jdk.CollectionConverters._
final case class StopTrainingJobRequest(trainingJobName: TrainingJobName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.StopTrainingJobRequest = {
    import StopTrainingJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.StopTrainingJobRequest
      .builder()
      .trainingJobName(
        TrainingJobName.unwrap(trainingJobName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.StopTrainingJobRequest.ReadOnly =
    zio.aws.sagemaker.model.StopTrainingJobRequest.wrap(buildAwsValue())
}
object StopTrainingJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.StopTrainingJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.StopTrainingJobRequest =
      zio.aws.sagemaker.model.StopTrainingJobRequest(trainingJobName)
    def trainingJobName: TrainingJobName
    def getTrainingJobName: ZIO[Any, Nothing, TrainingJobName] =
      ZIO.succeed(trainingJobName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.StopTrainingJobRequest
  ) extends zio.aws.sagemaker.model.StopTrainingJobRequest.ReadOnly {
    override val trainingJobName: TrainingJobName =
      zio.aws.sagemaker.model.primitives.TrainingJobName(impl.trainingJobName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.StopTrainingJobRequest
  ): zio.aws.sagemaker.model.StopTrainingJobRequest.ReadOnly = new Wrapper(impl)
}
