package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{KmsKeyId, S3Uri}
import scala.jdk.CollectionConverters._
final case class SharingSettings(
    notebookOutputOption: Optional[
      zio.aws.sagemaker.model.NotebookOutputOption
    ] = Optional.Absent,
    s3OutputPath: Optional[S3Uri] = Optional.Absent,
    s3KmsKeyId: Optional[KmsKeyId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.SharingSettings = {
    import SharingSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.SharingSettings
      .builder()
      .optionallyWith(notebookOutputOption.map(value => value.unwrap))(
        _.notebookOutputOption
      )
      .optionallyWith(
        s3OutputPath.map(value => S3Uri.unwrap(value): java.lang.String)
      )(_.s3OutputPath)
      .optionallyWith(
        s3KmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.s3KmsKeyId)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.SharingSettings.ReadOnly =
    zio.aws.sagemaker.model.SharingSettings.wrap(buildAwsValue())
}
object SharingSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.SharingSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.SharingSettings =
      zio.aws.sagemaker.model.SharingSettings(
        notebookOutputOption.map(value => value),
        s3OutputPath.map(value => value),
        s3KmsKeyId.map(value => value)
      )
    def notebookOutputOption
        : Optional[zio.aws.sagemaker.model.NotebookOutputOption]
    def s3OutputPath: Optional[S3Uri]
    def s3KmsKeyId: Optional[KmsKeyId]
    def getNotebookOutputOption
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.NotebookOutputOption] =
      AwsError.unwrapOptionField("notebookOutputOption", notebookOutputOption)
    def getS3OutputPath: ZIO[Any, AwsError, S3Uri] =
      AwsError.unwrapOptionField("s3OutputPath", s3OutputPath)
    def getS3KmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("s3KmsKeyId", s3KmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.SharingSettings
  ) extends zio.aws.sagemaker.model.SharingSettings.ReadOnly {
    override val notebookOutputOption
        : Optional[zio.aws.sagemaker.model.NotebookOutputOption] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notebookOutputOption())
        .map(value => zio.aws.sagemaker.model.NotebookOutputOption.wrap(value))
    override val s3OutputPath: Optional[S3Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.s3OutputPath())
      .map(value => zio.aws.sagemaker.model.primitives.S3Uri(value))
    override val s3KmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.s3KmsKeyId())
      .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.SharingSettings
  ): zio.aws.sagemaker.model.SharingSettings.ReadOnly = new Wrapper(impl)
}
