package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class MonitoringInput(
    endpointInput: zio.aws.sagemaker.model.EndpointInput
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.MonitoringInput = {
    import MonitoringInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.MonitoringInput
      .builder()
      .endpointInput(endpointInput.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.MonitoringInput.ReadOnly =
    zio.aws.sagemaker.model.MonitoringInput.wrap(buildAwsValue())
}
object MonitoringInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.MonitoringInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.MonitoringInput =
      zio.aws.sagemaker.model.MonitoringInput(endpointInput.asEditable)
    def endpointInput: zio.aws.sagemaker.model.EndpointInput.ReadOnly
    def getEndpointInput
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.EndpointInput.ReadOnly] =
      ZIO.succeed(endpointInput)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.MonitoringInput
  ) extends zio.aws.sagemaker.model.MonitoringInput.ReadOnly {
    override val endpointInput: zio.aws.sagemaker.model.EndpointInput.ReadOnly =
      zio.aws.sagemaker.model.EndpointInput.wrap(impl.endpointInput())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.MonitoringInput
  ): zio.aws.sagemaker.model.MonitoringInput.ReadOnly = new Wrapper(impl)
}
