package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.ArnOrName
import scala.jdk.CollectionConverters._
final case class DescribeAlgorithmRequest(algorithmName: ArnOrName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeAlgorithmRequest = {
    import DescribeAlgorithmRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeAlgorithmRequest
      .builder()
      .algorithmName(ArnOrName.unwrap(algorithmName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeAlgorithmRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeAlgorithmRequest.wrap(buildAwsValue())
}
object DescribeAlgorithmRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeAlgorithmRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeAlgorithmRequest =
      zio.aws.sagemaker.model.DescribeAlgorithmRequest(algorithmName)
    def algorithmName: ArnOrName
    def getAlgorithmName: ZIO[Any, Nothing, ArnOrName] =
      ZIO.succeed(algorithmName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeAlgorithmRequest
  ) extends zio.aws.sagemaker.model.DescribeAlgorithmRequest.ReadOnly {
    override val algorithmName: ArnOrName =
      zio.aws.sagemaker.model.primitives.ArnOrName(impl.algorithmName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeAlgorithmRequest
  ): zio.aws.sagemaker.model.DescribeAlgorithmRequest.ReadOnly = new Wrapper(
    impl
  )
}
