package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.CompilationJobArn
import scala.jdk.CollectionConverters._
final case class CreateCompilationJobResponse(
    compilationJobArn: CompilationJobArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateCompilationJobResponse = {
    import CreateCompilationJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateCompilationJobResponse
      .builder()
      .compilationJobArn(
        CompilationJobArn.unwrap(compilationJobArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.CreateCompilationJobResponse.ReadOnly =
    zio.aws.sagemaker.model.CreateCompilationJobResponse.wrap(buildAwsValue())
}
object CreateCompilationJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateCompilationJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateCompilationJobResponse =
      zio.aws.sagemaker.model.CreateCompilationJobResponse(compilationJobArn)
    def compilationJobArn: CompilationJobArn
    def getCompilationJobArn: ZIO[Any, Nothing, CompilationJobArn] =
      ZIO.succeed(compilationJobArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateCompilationJobResponse
  ) extends zio.aws.sagemaker.model.CreateCompilationJobResponse.ReadOnly {
    override val compilationJobArn: CompilationJobArn =
      zio.aws.sagemaker.model.primitives
        .CompilationJobArn(impl.compilationJobArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateCompilationJobResponse
  ): zio.aws.sagemaker.model.CreateCompilationJobResponse.ReadOnly =
    new Wrapper(impl)
}
