package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait AppNetworkAccessType {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.AppNetworkAccessType
}
object AppNetworkAccessType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.AppNetworkAccessType
  ): zio.aws.sagemaker.model.AppNetworkAccessType = value match {
    case software.amazon.awssdk.services.sagemaker.model.AppNetworkAccessType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.AppNetworkAccessType.PUBLIC_INTERNET_ONLY =>
      val r = PublicInternetOnly
      r
    case software.amazon.awssdk.services.sagemaker.model.AppNetworkAccessType.VPC_ONLY =>
      val r = VpcOnly
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.AppNetworkAccessType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppNetworkAccessType =
      software.amazon.awssdk.services.sagemaker.model.AppNetworkAccessType.UNKNOWN_TO_SDK_VERSION
  }
  case object PublicInternetOnly
      extends zio.aws.sagemaker.model.AppNetworkAccessType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppNetworkAccessType =
      software.amazon.awssdk.services.sagemaker.model.AppNetworkAccessType.PUBLIC_INTERNET_ONLY
  }
  case object VpcOnly extends zio.aws.sagemaker.model.AppNetworkAccessType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppNetworkAccessType =
      software.amazon.awssdk.services.sagemaker.model.AppNetworkAccessType.VPC_ONLY
  }
}
