package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{IdempotencyToken, CallbackToken}
import scala.jdk.CollectionConverters._
final case class SendPipelineExecutionStepSuccessRequest(
    callbackToken: CallbackToken,
    outputParameters: Optional[
      Iterable[zio.aws.sagemaker.model.OutputParameter]
    ] = Optional.Absent,
    clientRequestToken: Optional[IdempotencyToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.SendPipelineExecutionStepSuccessRequest = {
    import SendPipelineExecutionStepSuccessRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.SendPipelineExecutionStepSuccessRequest
      .builder()
      .callbackToken(CallbackToken.unwrap(callbackToken): java.lang.String)
      .optionallyWith(
        outputParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.outputParameters)
      .optionallyWith(
        clientRequestToken.map(value =>
          IdempotencyToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.SendPipelineExecutionStepSuccessRequest.ReadOnly =
    zio.aws.sagemaker.model.SendPipelineExecutionStepSuccessRequest
      .wrap(buildAwsValue())
}
object SendPipelineExecutionStepSuccessRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.SendPipelineExecutionStepSuccessRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.SendPipelineExecutionStepSuccessRequest =
      zio.aws.sagemaker.model.SendPipelineExecutionStepSuccessRequest(
        callbackToken,
        outputParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientRequestToken.map(value => value)
      )
    def callbackToken: CallbackToken
    def outputParameters
        : Optional[List[zio.aws.sagemaker.model.OutputParameter.ReadOnly]]
    def clientRequestToken: Optional[IdempotencyToken]
    def getCallbackToken: ZIO[Any, Nothing, CallbackToken] =
      ZIO.succeed(callbackToken)
    def getOutputParameters: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.OutputParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("outputParameters", outputParameters)
    def getClientRequestToken: ZIO[Any, AwsError, IdempotencyToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.SendPipelineExecutionStepSuccessRequest
  ) extends zio.aws.sagemaker.model.SendPipelineExecutionStepSuccessRequest.ReadOnly {
    override val callbackToken: CallbackToken =
      zio.aws.sagemaker.model.primitives.CallbackToken(impl.callbackToken())
    override val outputParameters
        : Optional[List[zio.aws.sagemaker.model.OutputParameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputParameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.OutputParameter.wrap(item)
          }.toList
        )
    override val clientRequestToken: Optional[IdempotencyToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.sagemaker.model.primitives.IdempotencyToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.SendPipelineExecutionStepSuccessRequest
  ): zio.aws.sagemaker.model.SendPipelineExecutionStepSuccessRequest.ReadOnly =
    new Wrapper(impl)
}
