package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  NextToken,
  FeatureGroupMaxResults,
  CreationTime,
  FeatureGroupNameContains
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListFeatureGroupsRequest(
    nameContains: Optional[FeatureGroupNameContains] = Optional.Absent,
    featureGroupStatusEquals: Optional[
      zio.aws.sagemaker.model.FeatureGroupStatus
    ] = Optional.Absent,
    offlineStoreStatusEquals: Optional[
      zio.aws.sagemaker.model.OfflineStoreStatusValue
    ] = Optional.Absent,
    creationTimeAfter: Optional[CreationTime] = Optional.Absent,
    creationTimeBefore: Optional[CreationTime] = Optional.Absent,
    sortOrder: Optional[zio.aws.sagemaker.model.FeatureGroupSortOrder] =
      Optional.Absent,
    sortBy: Optional[zio.aws.sagemaker.model.FeatureGroupSortBy] =
      Optional.Absent,
    maxResults: Optional[FeatureGroupMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListFeatureGroupsRequest = {
    import ListFeatureGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListFeatureGroupsRequest
      .builder()
      .optionallyWith(
        nameContains.map(value =>
          FeatureGroupNameContains.unwrap(value): java.lang.String
        )
      )(_.nameContains)
      .optionallyWith(featureGroupStatusEquals.map(value => value.unwrap))(
        _.featureGroupStatusEquals
      )
      .optionallyWith(offlineStoreStatusEquals.map(value => value.unwrap))(
        _.offlineStoreStatusEquals
      )
      .optionallyWith(
        creationTimeAfter.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTimeAfter)
      .optionallyWith(
        creationTimeBefore.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTimeBefore)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(
        maxResults.map(value => FeatureGroupMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListFeatureGroupsRequest.ReadOnly =
    zio.aws.sagemaker.model.ListFeatureGroupsRequest.wrap(buildAwsValue())
}
object ListFeatureGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListFeatureGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListFeatureGroupsRequest =
      zio.aws.sagemaker.model.ListFeatureGroupsRequest(
        nameContains.map(value => value),
        featureGroupStatusEquals.map(value => value),
        offlineStoreStatusEquals.map(value => value),
        creationTimeAfter.map(value => value),
        creationTimeBefore.map(value => value),
        sortOrder.map(value => value),
        sortBy.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def nameContains: Optional[FeatureGroupNameContains]
    def featureGroupStatusEquals
        : Optional[zio.aws.sagemaker.model.FeatureGroupStatus]
    def offlineStoreStatusEquals
        : Optional[zio.aws.sagemaker.model.OfflineStoreStatusValue]
    def creationTimeAfter: Optional[CreationTime]
    def creationTimeBefore: Optional[CreationTime]
    def sortOrder: Optional[zio.aws.sagemaker.model.FeatureGroupSortOrder]
    def sortBy: Optional[zio.aws.sagemaker.model.FeatureGroupSortBy]
    def maxResults: Optional[FeatureGroupMaxResults]
    def nextToken: Optional[NextToken]
    def getNameContains: ZIO[Any, AwsError, FeatureGroupNameContains] =
      AwsError.unwrapOptionField("nameContains", nameContains)
    def getFeatureGroupStatusEquals
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.FeatureGroupStatus] =
      AwsError.unwrapOptionField(
        "featureGroupStatusEquals",
        featureGroupStatusEquals
      )
    def getOfflineStoreStatusEquals
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.OfflineStoreStatusValue] =
      AwsError.unwrapOptionField(
        "offlineStoreStatusEquals",
        offlineStoreStatusEquals
      )
    def getCreationTimeAfter: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTimeAfter", creationTimeAfter)
    def getCreationTimeBefore: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTimeBefore", creationTimeBefore)
    def getSortOrder
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.FeatureGroupSortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getSortBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.FeatureGroupSortBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getMaxResults: ZIO[Any, AwsError, FeatureGroupMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListFeatureGroupsRequest
  ) extends zio.aws.sagemaker.model.ListFeatureGroupsRequest.ReadOnly {
    override val nameContains: Optional[FeatureGroupNameContains] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nameContains())
        .map(value =>
          zio.aws.sagemaker.model.primitives.FeatureGroupNameContains(value)
        )
    override val featureGroupStatusEquals
        : Optional[zio.aws.sagemaker.model.FeatureGroupStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.featureGroupStatusEquals())
        .map(value => zio.aws.sagemaker.model.FeatureGroupStatus.wrap(value))
    override val offlineStoreStatusEquals
        : Optional[zio.aws.sagemaker.model.OfflineStoreStatusValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.offlineStoreStatusEquals())
        .map(value =>
          zio.aws.sagemaker.model.OfflineStoreStatusValue.wrap(value)
        )
    override val creationTimeAfter: Optional[CreationTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTimeAfter())
        .map(value => zio.aws.sagemaker.model.primitives.CreationTime(value))
    override val creationTimeBefore: Optional[CreationTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTimeBefore())
        .map(value => zio.aws.sagemaker.model.primitives.CreationTime(value))
    override val sortOrder
        : Optional[zio.aws.sagemaker.model.FeatureGroupSortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.sagemaker.model.FeatureGroupSortOrder.wrap(value))
    override val sortBy: Optional[zio.aws.sagemaker.model.FeatureGroupSortBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value => zio.aws.sagemaker.model.FeatureGroupSortBy.wrap(value))
    override val maxResults: Optional[FeatureGroupMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.sagemaker.model.primitives.FeatureGroupMaxResults(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListFeatureGroupsRequest
  ): zio.aws.sagemaker.model.ListFeatureGroupsRequest.ReadOnly = new Wrapper(
    impl
  )
}
