package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.RecommendationJobName
import scala.jdk.CollectionConverters._
final case class DescribeInferenceRecommendationsJobRequest(
    jobName: RecommendationJobName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeInferenceRecommendationsJobRequest = {
    import DescribeInferenceRecommendationsJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeInferenceRecommendationsJobRequest
      .builder()
      .jobName(RecommendationJobName.unwrap(jobName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeInferenceRecommendationsJobRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeInferenceRecommendationsJobRequest
      .wrap(buildAwsValue())
}
object DescribeInferenceRecommendationsJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeInferenceRecommendationsJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.DescribeInferenceRecommendationsJobRequest =
      zio.aws.sagemaker.model
        .DescribeInferenceRecommendationsJobRequest(jobName)
    def jobName: RecommendationJobName
    def getJobName: ZIO[Any, Nothing, RecommendationJobName] =
      ZIO.succeed(jobName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeInferenceRecommendationsJobRequest
  ) extends zio.aws.sagemaker.model.DescribeInferenceRecommendationsJobRequest.ReadOnly {
    override val jobName: RecommendationJobName =
      zio.aws.sagemaker.model.primitives.RecommendationJobName(impl.jobName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeInferenceRecommendationsJobRequest
  ): zio.aws.sagemaker.model.DescribeInferenceRecommendationsJobRequest.ReadOnly =
    new Wrapper(impl)
}
