package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.{AppName, UserProfileName, DomainId}
import scala.jdk.CollectionConverters._
final case class DescribeAppRequest(
    domainId: DomainId,
    userProfileName: UserProfileName,
    appType: zio.aws.sagemaker.model.AppType,
    appName: AppName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeAppRequest = {
    import DescribeAppRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeAppRequest
      .builder()
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .userProfileName(
        UserProfileName.unwrap(userProfileName): java.lang.String
      )
      .appType(appType.unwrap)
      .appName(AppName.unwrap(appName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeAppRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeAppRequest.wrap(buildAwsValue())
}
object DescribeAppRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeAppRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeAppRequest =
      zio.aws.sagemaker.model.DescribeAppRequest(
        domainId,
        userProfileName,
        appType,
        appName
      )
    def domainId: DomainId
    def userProfileName: UserProfileName
    def appType: zio.aws.sagemaker.model.AppType
    def appName: AppName
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getUserProfileName: ZIO[Any, Nothing, UserProfileName] =
      ZIO.succeed(userProfileName)
    def getAppType: ZIO[Any, Nothing, zio.aws.sagemaker.model.AppType] =
      ZIO.succeed(appType)
    def getAppName: ZIO[Any, Nothing, AppName] = ZIO.succeed(appName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeAppRequest
  ) extends zio.aws.sagemaker.model.DescribeAppRequest.ReadOnly {
    override val domainId: DomainId =
      zio.aws.sagemaker.model.primitives.DomainId(impl.domainId())
    override val userProfileName: UserProfileName =
      zio.aws.sagemaker.model.primitives.UserProfileName(impl.userProfileName())
    override val appType: zio.aws.sagemaker.model.AppType =
      zio.aws.sagemaker.model.AppType.wrap(impl.appType())
    override val appName: AppName =
      zio.aws.sagemaker.model.primitives.AppName(impl.appName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeAppRequest
  ): zio.aws.sagemaker.model.DescribeAppRequest.ReadOnly = new Wrapper(impl)
}
