package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  IdempotencyToken,
  String256,
  CallbackToken
}
import scala.jdk.CollectionConverters._
final case class SendPipelineExecutionStepFailureRequest(
    callbackToken: CallbackToken,
    failureReason: Option[String256] = None,
    clientRequestToken: Option[IdempotencyToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.SendPipelineExecutionStepFailureRequest = {
    import SendPipelineExecutionStepFailureRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.SendPipelineExecutionStepFailureRequest
      .builder()
      .callbackToken(CallbackToken.unwrap(callbackToken): java.lang.String)
      .optionallyWith(
        failureReason.map(value => String256.unwrap(value): java.lang.String)
      )(_.failureReason)
      .optionallyWith(
        clientRequestToken.map(value =>
          IdempotencyToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.SendPipelineExecutionStepFailureRequest.ReadOnly =
    zio.aws.sagemaker.model.SendPipelineExecutionStepFailureRequest
      .wrap(buildAwsValue())
}
object SendPipelineExecutionStepFailureRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.SendPipelineExecutionStepFailureRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.SendPipelineExecutionStepFailureRequest =
      zio.aws.sagemaker.model.SendPipelineExecutionStepFailureRequest(
        callbackToken,
        failureReason.map(value => value),
        clientRequestToken.map(value => value)
      )
    def callbackToken: CallbackToken
    def failureReason: Option[String256]
    def clientRequestToken: Option[IdempotencyToken]
    def getCallbackToken: ZIO[Any, Nothing, CallbackToken] =
      ZIO.succeed(callbackToken)
    def getFailureReason: ZIO[Any, AwsError, String256] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getClientRequestToken: ZIO[Any, AwsError, IdempotencyToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.SendPipelineExecutionStepFailureRequest
  ) extends zio.aws.sagemaker.model.SendPipelineExecutionStepFailureRequest.ReadOnly {
    override val callbackToken: CallbackToken =
      zio.aws.sagemaker.model.primitives.CallbackToken(impl.callbackToken())
    override val failureReason: Option[String256] = scala
      .Option(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.String256(value))
    override val clientRequestToken: Option[IdempotencyToken] = scala
      .Option(impl.clientRequestToken())
      .map(value => zio.aws.sagemaker.model.primitives.IdempotencyToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.SendPipelineExecutionStepFailureRequest
  ): zio.aws.sagemaker.model.SendPipelineExecutionStepFailureRequest.ReadOnly =
    new Wrapper(impl)
}
