package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RetentionPolicy(
    homeEfsFileSystem: Option[zio.aws.sagemaker.model.RetentionType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.RetentionPolicy = {
    import RetentionPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.RetentionPolicy
      .builder()
      .optionallyWith(homeEfsFileSystem.map(value => value.unwrap))(
        _.homeEfsFileSystem
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.RetentionPolicy.ReadOnly =
    zio.aws.sagemaker.model.RetentionPolicy.wrap(buildAwsValue())
}
object RetentionPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.RetentionPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.RetentionPolicy =
      zio.aws.sagemaker.model
        .RetentionPolicy(homeEfsFileSystem.map(value => value))
    def homeEfsFileSystem: Option[zio.aws.sagemaker.model.RetentionType]
    def getHomeEfsFileSystem
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.RetentionType] =
      AwsError.unwrapOptionField("homeEfsFileSystem", homeEfsFileSystem)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.RetentionPolicy
  ) extends zio.aws.sagemaker.model.RetentionPolicy.ReadOnly {
    override val homeEfsFileSystem
        : Option[zio.aws.sagemaker.model.RetentionType] = scala
      .Option(impl.homeEfsFileSystem())
      .map(value => zio.aws.sagemaker.model.RetentionType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.RetentionPolicy
  ): zio.aws.sagemaker.model.RetentionPolicy.ReadOnly = new Wrapper(impl)
}
