package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{String256, Timestamp, String40}
import scala.jdk.CollectionConverters._
final case class QueryFilters(
    types: Option[Iterable[String40]] = None,
    lineageTypes: Option[Iterable[zio.aws.sagemaker.model.LineageType]] = None,
    createdBefore: Option[Timestamp] = None,
    createdAfter: Option[Timestamp] = None,
    modifiedBefore: Option[Timestamp] = None,
    modifiedAfter: Option[Timestamp] = None,
    properties: Option[Map[String256, String256]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.QueryFilters = {
    import QueryFilters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.QueryFilters
      .builder()
      .optionallyWith(
        types.map(value =>
          value.map { item =>
            String40.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.types)
      .optionallyWith(
        lineageTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.lineageTypesWithStrings)
      .optionallyWith(
        createdBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdBefore)
      .optionallyWith(
        createdAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdAfter)
      .optionallyWith(
        modifiedBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.modifiedBefore)
      .optionallyWith(
        modifiedAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.modifiedAfter)
      .optionallyWith(
        properties.map(value =>
          value
            .map({ case (key, value) =>
              (String256.unwrap(key): java.lang.String) -> (String256
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.properties)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.QueryFilters.ReadOnly =
    zio.aws.sagemaker.model.QueryFilters.wrap(buildAwsValue())
}
object QueryFilters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.QueryFilters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.QueryFilters =
      zio.aws.sagemaker.model.QueryFilters(
        types.map(value => value),
        lineageTypes.map(value => value),
        createdBefore.map(value => value),
        createdAfter.map(value => value),
        modifiedBefore.map(value => value),
        modifiedAfter.map(value => value),
        properties.map(value => value)
      )
    def types: Option[List[String40]]
    def lineageTypes: Option[List[zio.aws.sagemaker.model.LineageType]]
    def createdBefore: Option[Timestamp]
    def createdAfter: Option[Timestamp]
    def modifiedBefore: Option[Timestamp]
    def modifiedAfter: Option[Timestamp]
    def properties: Option[Map[String256, String256]]
    def getTypes: ZIO[Any, AwsError, List[String40]] =
      AwsError.unwrapOptionField("types", types)
    def getLineageTypes
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.LineageType]] =
      AwsError.unwrapOptionField("lineageTypes", lineageTypes)
    def getCreatedBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdBefore", createdBefore)
    def getCreatedAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAfter", createdAfter)
    def getModifiedBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("modifiedBefore", modifiedBefore)
    def getModifiedAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("modifiedAfter", modifiedAfter)
    def getProperties: ZIO[Any, AwsError, Map[String256, String256]] =
      AwsError.unwrapOptionField("properties", properties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.QueryFilters
  ) extends zio.aws.sagemaker.model.QueryFilters.ReadOnly {
    override val types: Option[List[String40]] = scala
      .Option(impl.types())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.primitives.String40(item)
        }.toList
      )
    override val lineageTypes
        : Option[List[zio.aws.sagemaker.model.LineageType]] = scala
      .Option(impl.lineageTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.LineageType.wrap(item)
        }.toList
      )
    override val createdBefore: Option[Timestamp] = scala
      .Option(impl.createdBefore())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val createdAfter: Option[Timestamp] = scala
      .Option(impl.createdAfter())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val modifiedBefore: Option[Timestamp] = scala
      .Option(impl.modifiedBefore())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val modifiedAfter: Option[Timestamp] = scala
      .Option(impl.modifiedAfter())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val properties: Option[Map[String256, String256]] = scala
      .Option(impl.properties())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.sagemaker.model.primitives.String256(
              key
            ) -> zio.aws.sagemaker.model.primitives.String256(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.QueryFilters
  ): zio.aws.sagemaker.model.QueryFilters.ReadOnly = new Wrapper(impl)
}
