package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  ConfigValue,
  ConfigKey,
  ProfilingIntervalInMilliseconds,
  S3Uri
}
import scala.jdk.CollectionConverters._
final case class ProfilerConfig(
    s3OutputPath: S3Uri,
    profilingIntervalInMilliseconds: Option[ProfilingIntervalInMilliseconds] =
      None,
    profilingParameters: Option[Map[ConfigKey, ConfigValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ProfilerConfig = {
    import ProfilerConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ProfilerConfig
      .builder()
      .s3OutputPath(S3Uri.unwrap(s3OutputPath): java.lang.String)
      .optionallyWith(
        profilingIntervalInMilliseconds.map(value =>
          ProfilingIntervalInMilliseconds.unwrap(value): java.lang.Long
        )
      )(_.profilingIntervalInMilliseconds)
      .optionallyWith(
        profilingParameters.map(value =>
          value
            .map({ case (key, value) =>
              (ConfigKey.unwrap(key): java.lang.String) -> (ConfigValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.profilingParameters)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ProfilerConfig.ReadOnly =
    zio.aws.sagemaker.model.ProfilerConfig.wrap(buildAwsValue())
}
object ProfilerConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ProfilerConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ProfilerConfig =
      zio.aws.sagemaker.model.ProfilerConfig(
        s3OutputPath,
        profilingIntervalInMilliseconds.map(value => value),
        profilingParameters.map(value => value)
      )
    def s3OutputPath: S3Uri
    def profilingIntervalInMilliseconds: Option[ProfilingIntervalInMilliseconds]
    def profilingParameters: Option[Map[ConfigKey, ConfigValue]]
    def getS3OutputPath: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(s3OutputPath)
    def getProfilingIntervalInMilliseconds
        : ZIO[Any, AwsError, ProfilingIntervalInMilliseconds] =
      AwsError.unwrapOptionField(
        "profilingIntervalInMilliseconds",
        profilingIntervalInMilliseconds
      )
    def getProfilingParameters
        : ZIO[Any, AwsError, Map[ConfigKey, ConfigValue]] =
      AwsError.unwrapOptionField("profilingParameters", profilingParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ProfilerConfig
  ) extends zio.aws.sagemaker.model.ProfilerConfig.ReadOnly {
    override val s3OutputPath: S3Uri =
      zio.aws.sagemaker.model.primitives.S3Uri(impl.s3OutputPath())
    override val profilingIntervalInMilliseconds
        : Option[ProfilingIntervalInMilliseconds] = scala
      .Option(impl.profilingIntervalInMilliseconds())
      .map(value =>
        zio.aws.sagemaker.model.primitives
          .ProfilingIntervalInMilliseconds(value)
      )
    override val profilingParameters: Option[Map[ConfigKey, ConfigValue]] =
      scala
        .Option(impl.profilingParameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.sagemaker.model.primitives.ConfigKey(
                key
              ) -> zio.aws.sagemaker.model.primitives.ConfigValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ProfilerConfig
  ): zio.aws.sagemaker.model.ProfilerConfig.ReadOnly = new Wrapper(impl)
}
