package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.ProcessingJobName
import scala.jdk.CollectionConverters._
final case class ModelQualityBaselineConfig(
    baseliningJobName: Option[ProcessingJobName] = None,
    constraintsResource: Option[
      zio.aws.sagemaker.model.MonitoringConstraintsResource
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ModelQualityBaselineConfig = {
    import ModelQualityBaselineConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ModelQualityBaselineConfig
      .builder()
      .optionallyWith(
        baseliningJobName.map(value =>
          ProcessingJobName.unwrap(value): java.lang.String
        )
      )(_.baseliningJobName)
      .optionallyWith(constraintsResource.map(value => value.buildAwsValue()))(
        _.constraintsResource
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ModelQualityBaselineConfig.ReadOnly =
    zio.aws.sagemaker.model.ModelQualityBaselineConfig.wrap(buildAwsValue())
}
object ModelQualityBaselineConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ModelQualityBaselineConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ModelQualityBaselineConfig =
      zio.aws.sagemaker.model.ModelQualityBaselineConfig(
        baseliningJobName.map(value => value),
        constraintsResource.map(value => value.asEditable)
      )
    def baseliningJobName: Option[ProcessingJobName]
    def constraintsResource
        : Option[zio.aws.sagemaker.model.MonitoringConstraintsResource.ReadOnly]
    def getBaseliningJobName: ZIO[Any, AwsError, ProcessingJobName] =
      AwsError.unwrapOptionField("baseliningJobName", baseliningJobName)
    def getConstraintsResource: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MonitoringConstraintsResource.ReadOnly
    ] = AwsError.unwrapOptionField("constraintsResource", constraintsResource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelQualityBaselineConfig
  ) extends zio.aws.sagemaker.model.ModelQualityBaselineConfig.ReadOnly {
    override val baseliningJobName: Option[ProcessingJobName] = scala
      .Option(impl.baseliningJobName())
      .map(value => zio.aws.sagemaker.model.primitives.ProcessingJobName(value))
    override val constraintsResource: Option[
      zio.aws.sagemaker.model.MonitoringConstraintsResource.ReadOnly
    ] = scala
      .Option(impl.constraintsResource())
      .map(value =>
        zio.aws.sagemaker.model.MonitoringConstraintsResource.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelQualityBaselineConfig
  ): zio.aws.sagemaker.model.ModelQualityBaselineConfig.ReadOnly = new Wrapper(
    impl
  )
}
