package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListPipelineParametersForExecutionResponse(
    pipelineParameters: Option[Iterable[zio.aws.sagemaker.model.Parameter]] =
      None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListPipelineParametersForExecutionResponse = {
    import ListPipelineParametersForExecutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListPipelineParametersForExecutionResponse
      .builder()
      .optionallyWith(
        pipelineParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.pipelineParameters)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListPipelineParametersForExecutionResponse.ReadOnly =
    zio.aws.sagemaker.model.ListPipelineParametersForExecutionResponse
      .wrap(buildAwsValue())
}
object ListPipelineParametersForExecutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListPipelineParametersForExecutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.ListPipelineParametersForExecutionResponse =
      zio.aws.sagemaker.model.ListPipelineParametersForExecutionResponse(
        pipelineParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def pipelineParameters
        : Option[List[zio.aws.sagemaker.model.Parameter.ReadOnly]]
    def nextToken: Option[NextToken]
    def getPipelineParameters
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Parameter.ReadOnly]] =
      AwsError.unwrapOptionField("pipelineParameters", pipelineParameters)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListPipelineParametersForExecutionResponse
  ) extends zio.aws.sagemaker.model.ListPipelineParametersForExecutionResponse.ReadOnly {
    override val pipelineParameters
        : Option[List[zio.aws.sagemaker.model.Parameter.ReadOnly]] = scala
      .Option(impl.pipelineParameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.Parameter.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListPipelineParametersForExecutionResponse
  ): zio.aws.sagemaker.model.ListPipelineParametersForExecutionResponse.ReadOnly =
    new Wrapper(impl)
}
