package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListModelMetadataResponse(
    modelMetadataSummaries: Iterable[
      zio.aws.sagemaker.model.ModelMetadataSummary
    ],
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListModelMetadataResponse = {
    import ListModelMetadataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListModelMetadataResponse
      .builder()
      .modelMetadataSummaries(modelMetadataSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListModelMetadataResponse.ReadOnly =
    zio.aws.sagemaker.model.ListModelMetadataResponse.wrap(buildAwsValue())
}
object ListModelMetadataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListModelMetadataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListModelMetadataResponse =
      zio.aws.sagemaker.model.ListModelMetadataResponse(
        modelMetadataSummaries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def modelMetadataSummaries
        : List[zio.aws.sagemaker.model.ModelMetadataSummary.ReadOnly]
    def nextToken: Option[NextToken]
    def getModelMetadataSummaries: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.ModelMetadataSummary.ReadOnly
    ]] = ZIO.succeed(modelMetadataSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListModelMetadataResponse
  ) extends zio.aws.sagemaker.model.ListModelMetadataResponse.ReadOnly {
    override val modelMetadataSummaries
        : List[zio.aws.sagemaker.model.ModelMetadataSummary.ReadOnly] = impl
      .modelMetadataSummaries()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.ModelMetadataSummary.wrap(item)
      }
      .toList
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListModelMetadataResponse
  ): zio.aws.sagemaker.model.ListModelMetadataResponse.ReadOnly = new Wrapper(
    impl
  )
}
