package zio.aws.sagemaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  NextToken,
  AutoMLMaxResults,
  CandidateName,
  AutoMLJobName
}
import scala.jdk.CollectionConverters._
final case class ListCandidatesForAutoMlJobRequest(
    autoMLJobName: AutoMLJobName,
    statusEquals: Option[zio.aws.sagemaker.model.CandidateStatus] = None,
    candidateNameEquals: Option[CandidateName] = None,
    sortOrder: Option[zio.aws.sagemaker.model.AutoMLSortOrder] = None,
    sortBy: Option[zio.aws.sagemaker.model.CandidateSortBy] = None,
    maxResults: Option[AutoMLMaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListCandidatesForAutoMlJobRequest = {
    import ListCandidatesForAutoMlJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListCandidatesForAutoMlJobRequest
      .builder()
      .autoMLJobName(AutoMLJobName.unwrap(autoMLJobName): java.lang.String)
      .optionallyWith(statusEquals.map(value => value.unwrap))(_.statusEquals)
      .optionallyWith(
        candidateNameEquals.map(value =>
          CandidateName.unwrap(value): java.lang.String
        )
      )(_.candidateNameEquals)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(
        maxResults.map(value => AutoMLMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListCandidatesForAutoMlJobRequest.ReadOnly =
    zio.aws.sagemaker.model.ListCandidatesForAutoMlJobRequest
      .wrap(buildAwsValue())
}
object ListCandidatesForAutoMlJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListCandidatesForAutoMlJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListCandidatesForAutoMlJobRequest =
      zio.aws.sagemaker.model.ListCandidatesForAutoMlJobRequest(
        autoMLJobName,
        statusEquals.map(value => value),
        candidateNameEquals.map(value => value),
        sortOrder.map(value => value),
        sortBy.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def autoMLJobName: AutoMLJobName
    def statusEquals: Option[zio.aws.sagemaker.model.CandidateStatus]
    def candidateNameEquals: Option[CandidateName]
    def sortOrder: Option[zio.aws.sagemaker.model.AutoMLSortOrder]
    def sortBy: Option[zio.aws.sagemaker.model.CandidateSortBy]
    def maxResults: Option[AutoMLMaxResults]
    def nextToken: Option[NextToken]
    def getAutoMLJobName: ZIO[Any, Nothing, AutoMLJobName] =
      ZIO.succeed(autoMLJobName)
    def getStatusEquals
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.CandidateStatus] =
      AwsError.unwrapOptionField("statusEquals", statusEquals)
    def getCandidateNameEquals: ZIO[Any, AwsError, CandidateName] =
      AwsError.unwrapOptionField("candidateNameEquals", candidateNameEquals)
    def getSortOrder
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.AutoMLSortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getSortBy: ZIO[Any, AwsError, zio.aws.sagemaker.model.CandidateSortBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getMaxResults: ZIO[Any, AwsError, AutoMLMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListCandidatesForAutoMlJobRequest
  ) extends zio.aws.sagemaker.model.ListCandidatesForAutoMlJobRequest.ReadOnly {
    override val autoMLJobName: AutoMLJobName =
      zio.aws.sagemaker.model.primitives.AutoMLJobName(impl.autoMLJobName())
    override val statusEquals: Option[zio.aws.sagemaker.model.CandidateStatus] =
      scala
        .Option(impl.statusEquals())
        .map(value => zio.aws.sagemaker.model.CandidateStatus.wrap(value))
    override val candidateNameEquals: Option[CandidateName] = scala
      .Option(impl.candidateNameEquals())
      .map(value => zio.aws.sagemaker.model.primitives.CandidateName(value))
    override val sortOrder: Option[zio.aws.sagemaker.model.AutoMLSortOrder] =
      scala
        .Option(impl.sortOrder())
        .map(value => zio.aws.sagemaker.model.AutoMLSortOrder.wrap(value))
    override val sortBy: Option[zio.aws.sagemaker.model.CandidateSortBy] = scala
      .Option(impl.sortBy())
      .map(value => zio.aws.sagemaker.model.CandidateSortBy.wrap(value))
    override val maxResults: Option[AutoMLMaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.AutoMLMaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListCandidatesForAutoMlJobRequest
  ): zio.aws.sagemaker.model.ListCandidatesForAutoMlJobRequest.ReadOnly =
    new Wrapper(impl)
}
