package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  NextToken,
  Timestamp,
  MaxResults,
  SourceUri,
  String256
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListActionsRequest(
    sourceUri: Option[SourceUri] = None,
    actionType: Option[String256] = None,
    createdAfter: Option[Timestamp] = None,
    createdBefore: Option[Timestamp] = None,
    sortBy: Option[zio.aws.sagemaker.model.SortActionsBy] = None,
    sortOrder: Option[zio.aws.sagemaker.model.SortOrder] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListActionsRequest = {
    import ListActionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListActionsRequest
      .builder()
      .optionallyWith(
        sourceUri.map(value => SourceUri.unwrap(value): java.lang.String)
      )(_.sourceUri)
      .optionallyWith(
        actionType.map(value => String256.unwrap(value): java.lang.String)
      )(_.actionType)
      .optionallyWith(
        createdAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdAfter)
      .optionallyWith(
        createdBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdBefore)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListActionsRequest.ReadOnly =
    zio.aws.sagemaker.model.ListActionsRequest.wrap(buildAwsValue())
}
object ListActionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListActionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListActionsRequest =
      zio.aws.sagemaker.model.ListActionsRequest(
        sourceUri.map(value => value),
        actionType.map(value => value),
        createdAfter.map(value => value),
        createdBefore.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def sourceUri: Option[SourceUri]
    def actionType: Option[String256]
    def createdAfter: Option[Timestamp]
    def createdBefore: Option[Timestamp]
    def sortBy: Option[zio.aws.sagemaker.model.SortActionsBy]
    def sortOrder: Option[zio.aws.sagemaker.model.SortOrder]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getSourceUri: ZIO[Any, AwsError, SourceUri] =
      AwsError.unwrapOptionField("sourceUri", sourceUri)
    def getActionType: ZIO[Any, AwsError, String256] =
      AwsError.unwrapOptionField("actionType", actionType)
    def getCreatedAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAfter", createdAfter)
    def getCreatedBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdBefore", createdBefore)
    def getSortBy: ZIO[Any, AwsError, zio.aws.sagemaker.model.SortActionsBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.sagemaker.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListActionsRequest
  ) extends zio.aws.sagemaker.model.ListActionsRequest.ReadOnly {
    override val sourceUri: Option[SourceUri] = scala
      .Option(impl.sourceUri())
      .map(value => zio.aws.sagemaker.model.primitives.SourceUri(value))
    override val actionType: Option[String256] = scala
      .Option(impl.actionType())
      .map(value => zio.aws.sagemaker.model.primitives.String256(value))
    override val createdAfter: Option[Timestamp] = scala
      .Option(impl.createdAfter())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val createdBefore: Option[Timestamp] = scala
      .Option(impl.createdBefore())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val sortBy: Option[zio.aws.sagemaker.model.SortActionsBy] = scala
      .Option(impl.sortBy())
      .map(value => zio.aws.sagemaker.model.SortActionsBy.wrap(value))
    override val sortOrder: Option[zio.aws.sagemaker.model.SortOrder] = scala
      .Option(impl.sortOrder())
      .map(value => zio.aws.sagemaker.model.SortOrder.wrap(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListActionsRequest
  ): zio.aws.sagemaker.model.ListActionsRequest.ReadOnly = new Wrapper(impl)
}
