package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  DeviceFleetDescription,
  EntityName,
  DeviceFleetArn
}
import scala.jdk.CollectionConverters._
final case class GetDeviceFleetReportResponse(
    deviceFleetArn: DeviceFleetArn,
    deviceFleetName: EntityName,
    outputConfig: Option[zio.aws.sagemaker.model.EdgeOutputConfig] = None,
    description: Option[DeviceFleetDescription] = None,
    reportGenerated: Option[Timestamp] = None,
    deviceStats: Option[zio.aws.sagemaker.model.DeviceStats] = None,
    agentVersions: Option[Iterable[zio.aws.sagemaker.model.AgentVersion]] =
      None,
    modelStats: Option[Iterable[zio.aws.sagemaker.model.EdgeModelStat]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.GetDeviceFleetReportResponse = {
    import GetDeviceFleetReportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.GetDeviceFleetReportResponse
      .builder()
      .deviceFleetArn(DeviceFleetArn.unwrap(deviceFleetArn): java.lang.String)
      .deviceFleetName(EntityName.unwrap(deviceFleetName): java.lang.String)
      .optionallyWith(outputConfig.map(value => value.buildAwsValue()))(
        _.outputConfig
      )
      .optionallyWith(
        description.map(value =>
          DeviceFleetDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        reportGenerated.map(value => Timestamp.unwrap(value): Instant)
      )(_.reportGenerated)
      .optionallyWith(deviceStats.map(value => value.buildAwsValue()))(
        _.deviceStats
      )
      .optionallyWith(
        agentVersions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.agentVersions)
      .optionallyWith(
        modelStats.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.modelStats)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.GetDeviceFleetReportResponse.ReadOnly =
    zio.aws.sagemaker.model.GetDeviceFleetReportResponse.wrap(buildAwsValue())
}
object GetDeviceFleetReportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.GetDeviceFleetReportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.GetDeviceFleetReportResponse =
      zio.aws.sagemaker.model.GetDeviceFleetReportResponse(
        deviceFleetArn,
        deviceFleetName,
        outputConfig.map(value => value.asEditable),
        description.map(value => value),
        reportGenerated.map(value => value),
        deviceStats.map(value => value.asEditable),
        agentVersions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        modelStats.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def deviceFleetArn: DeviceFleetArn
    def deviceFleetName: EntityName
    def outputConfig: Option[zio.aws.sagemaker.model.EdgeOutputConfig.ReadOnly]
    def description: Option[DeviceFleetDescription]
    def reportGenerated: Option[Timestamp]
    def deviceStats: Option[zio.aws.sagemaker.model.DeviceStats.ReadOnly]
    def agentVersions
        : Option[List[zio.aws.sagemaker.model.AgentVersion.ReadOnly]]
    def modelStats: Option[List[zio.aws.sagemaker.model.EdgeModelStat.ReadOnly]]
    def getDeviceFleetArn: ZIO[Any, Nothing, DeviceFleetArn] =
      ZIO.succeed(deviceFleetArn)
    def getDeviceFleetName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(deviceFleetName)
    def getOutputConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.EdgeOutputConfig.ReadOnly
    ] = AwsError.unwrapOptionField("outputConfig", outputConfig)
    def getDescription: ZIO[Any, AwsError, DeviceFleetDescription] =
      AwsError.unwrapOptionField("description", description)
    def getReportGenerated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("reportGenerated", reportGenerated)
    def getDeviceStats
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.DeviceStats.ReadOnly] =
      AwsError.unwrapOptionField("deviceStats", deviceStats)
    def getAgentVersions: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.AgentVersion.ReadOnly
    ]] = AwsError.unwrapOptionField("agentVersions", agentVersions)
    def getModelStats: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.EdgeModelStat.ReadOnly
    ]] = AwsError.unwrapOptionField("modelStats", modelStats)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.GetDeviceFleetReportResponse
  ) extends zio.aws.sagemaker.model.GetDeviceFleetReportResponse.ReadOnly {
    override val deviceFleetArn: DeviceFleetArn =
      zio.aws.sagemaker.model.primitives.DeviceFleetArn(impl.deviceFleetArn())
    override val deviceFleetName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.deviceFleetName())
    override val outputConfig
        : Option[zio.aws.sagemaker.model.EdgeOutputConfig.ReadOnly] = scala
      .Option(impl.outputConfig())
      .map(value => zio.aws.sagemaker.model.EdgeOutputConfig.wrap(value))
    override val description: Option[DeviceFleetDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.sagemaker.model.primitives.DeviceFleetDescription(value)
      )
    override val reportGenerated: Option[Timestamp] = scala
      .Option(impl.reportGenerated())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val deviceStats
        : Option[zio.aws.sagemaker.model.DeviceStats.ReadOnly] = scala
      .Option(impl.deviceStats())
      .map(value => zio.aws.sagemaker.model.DeviceStats.wrap(value))
    override val agentVersions
        : Option[List[zio.aws.sagemaker.model.AgentVersion.ReadOnly]] = scala
      .Option(impl.agentVersions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.AgentVersion.wrap(item)
        }.toList
      )
    override val modelStats
        : Option[List[zio.aws.sagemaker.model.EdgeModelStat.ReadOnly]] = scala
      .Option(impl.modelStats())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.EdgeModelStat.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.GetDeviceFleetReportResponse
  ): zio.aws.sagemaker.model.GetDeviceFleetReportResponse.ReadOnly =
    new Wrapper(impl)
}
