package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  MonitoringTimeOffsetString,
  ProbabilityThresholdAttribute,
  ProcessingLocalPath,
  EndpointName
}
import scala.jdk.CollectionConverters._
final case class EndpointInput(
    endpointName: EndpointName,
    localPath: ProcessingLocalPath,
    s3InputMode: Option[zio.aws.sagemaker.model.ProcessingS3InputMode] = None,
    s3DataDistributionType: Option[
      zio.aws.sagemaker.model.ProcessingS3DataDistributionType
    ] = None,
    featuresAttribute: Option[String] = None,
    inferenceAttribute: Option[String] = None,
    probabilityAttribute: Option[String] = None,
    probabilityThresholdAttribute: Option[ProbabilityThresholdAttribute] = None,
    startTimeOffset: Option[MonitoringTimeOffsetString] = None,
    endTimeOffset: Option[MonitoringTimeOffsetString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.EndpointInput = {
    import EndpointInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.EndpointInput
      .builder()
      .endpointName(EndpointName.unwrap(endpointName): java.lang.String)
      .localPath(ProcessingLocalPath.unwrap(localPath): java.lang.String)
      .optionallyWith(s3InputMode.map(value => value.unwrap))(_.s3InputMode)
      .optionallyWith(s3DataDistributionType.map(value => value.unwrap))(
        _.s3DataDistributionType
      )
      .optionallyWith(featuresAttribute.map(value => value: java.lang.String))(
        _.featuresAttribute
      )
      .optionallyWith(inferenceAttribute.map(value => value: java.lang.String))(
        _.inferenceAttribute
      )
      .optionallyWith(
        probabilityAttribute.map(value => value: java.lang.String)
      )(_.probabilityAttribute)
      .optionallyWith(
        probabilityThresholdAttribute.map(value =>
          ProbabilityThresholdAttribute.unwrap(value): java.lang.Double
        )
      )(_.probabilityThresholdAttribute)
      .optionallyWith(
        startTimeOffset.map(value =>
          MonitoringTimeOffsetString.unwrap(value): java.lang.String
        )
      )(_.startTimeOffset)
      .optionallyWith(
        endTimeOffset.map(value =>
          MonitoringTimeOffsetString.unwrap(value): java.lang.String
        )
      )(_.endTimeOffset)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.EndpointInput.ReadOnly =
    zio.aws.sagemaker.model.EndpointInput.wrap(buildAwsValue())
}
object EndpointInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.EndpointInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.EndpointInput =
      zio.aws.sagemaker.model.EndpointInput(
        endpointName,
        localPath,
        s3InputMode.map(value => value),
        s3DataDistributionType.map(value => value),
        featuresAttribute.map(value => value),
        inferenceAttribute.map(value => value),
        probabilityAttribute.map(value => value),
        probabilityThresholdAttribute.map(value => value),
        startTimeOffset.map(value => value),
        endTimeOffset.map(value => value)
      )
    def endpointName: EndpointName
    def localPath: ProcessingLocalPath
    def s3InputMode: Option[zio.aws.sagemaker.model.ProcessingS3InputMode]
    def s3DataDistributionType
        : Option[zio.aws.sagemaker.model.ProcessingS3DataDistributionType]
    def featuresAttribute: Option[String]
    def inferenceAttribute: Option[String]
    def probabilityAttribute: Option[String]
    def probabilityThresholdAttribute: Option[ProbabilityThresholdAttribute]
    def startTimeOffset: Option[MonitoringTimeOffsetString]
    def endTimeOffset: Option[MonitoringTimeOffsetString]
    def getEndpointName: ZIO[Any, Nothing, EndpointName] =
      ZIO.succeed(endpointName)
    def getLocalPath: ZIO[Any, Nothing, ProcessingLocalPath] =
      ZIO.succeed(localPath)
    def getS3InputMode
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ProcessingS3InputMode] =
      AwsError.unwrapOptionField("s3InputMode", s3InputMode)
    def getS3DataDistributionType: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ProcessingS3DataDistributionType
    ] = AwsError.unwrapOptionField(
      "s3DataDistributionType",
      s3DataDistributionType
    )
    def getFeaturesAttribute: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("featuresAttribute", featuresAttribute)
    def getInferenceAttribute: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("inferenceAttribute", inferenceAttribute)
    def getProbabilityAttribute: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("probabilityAttribute", probabilityAttribute)
    def getProbabilityThresholdAttribute
        : ZIO[Any, AwsError, ProbabilityThresholdAttribute] =
      AwsError.unwrapOptionField(
        "probabilityThresholdAttribute",
        probabilityThresholdAttribute
      )
    def getStartTimeOffset: ZIO[Any, AwsError, MonitoringTimeOffsetString] =
      AwsError.unwrapOptionField("startTimeOffset", startTimeOffset)
    def getEndTimeOffset: ZIO[Any, AwsError, MonitoringTimeOffsetString] =
      AwsError.unwrapOptionField("endTimeOffset", endTimeOffset)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.EndpointInput
  ) extends zio.aws.sagemaker.model.EndpointInput.ReadOnly {
    override val endpointName: EndpointName =
      zio.aws.sagemaker.model.primitives.EndpointName(impl.endpointName())
    override val localPath: ProcessingLocalPath =
      zio.aws.sagemaker.model.primitives.ProcessingLocalPath(impl.localPath())
    override val s3InputMode
        : Option[zio.aws.sagemaker.model.ProcessingS3InputMode] = scala
      .Option(impl.s3InputMode())
      .map(value => zio.aws.sagemaker.model.ProcessingS3InputMode.wrap(value))
    override val s3DataDistributionType
        : Option[zio.aws.sagemaker.model.ProcessingS3DataDistributionType] =
      scala
        .Option(impl.s3DataDistributionType())
        .map(value =>
          zio.aws.sagemaker.model.ProcessingS3DataDistributionType.wrap(value)
        )
    override val featuresAttribute: Option[String] =
      scala.Option(impl.featuresAttribute()).map(value => value: String)
    override val inferenceAttribute: Option[String] =
      scala.Option(impl.inferenceAttribute()).map(value => value: String)
    override val probabilityAttribute: Option[String] =
      scala.Option(impl.probabilityAttribute()).map(value => value: String)
    override val probabilityThresholdAttribute
        : Option[ProbabilityThresholdAttribute] = scala
      .Option(impl.probabilityThresholdAttribute())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ProbabilityThresholdAttribute(value)
      )
    override val startTimeOffset: Option[MonitoringTimeOffsetString] = scala
      .Option(impl.startTimeOffset())
      .map(value =>
        zio.aws.sagemaker.model.primitives.MonitoringTimeOffsetString(value)
      )
    override val endTimeOffset: Option[MonitoringTimeOffsetString] = scala
      .Option(impl.endTimeOffset())
      .map(value =>
        zio.aws.sagemaker.model.primitives.MonitoringTimeOffsetString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.EndpointInput
  ): zio.aws.sagemaker.model.EndpointInput.ReadOnly = new Wrapper(impl)
}
