package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  RoleArn,
  Timestamp,
  MonitoringJobDefinitionName,
  MonitoringJobDefinitionArn
}
import scala.jdk.CollectionConverters._
final case class DescribeModelQualityJobDefinitionResponse(
    jobDefinitionArn: MonitoringJobDefinitionArn,
    jobDefinitionName: MonitoringJobDefinitionName,
    creationTime: Timestamp,
    modelQualityBaselineConfig: Option[
      zio.aws.sagemaker.model.ModelQualityBaselineConfig
    ] = None,
    modelQualityAppSpecification: zio.aws.sagemaker.model.ModelQualityAppSpecification,
    modelQualityJobInput: zio.aws.sagemaker.model.ModelQualityJobInput,
    modelQualityJobOutputConfig: zio.aws.sagemaker.model.MonitoringOutputConfig,
    jobResources: zio.aws.sagemaker.model.MonitoringResources,
    networkConfig: Option[zio.aws.sagemaker.model.MonitoringNetworkConfig] =
      None,
    roleArn: RoleArn,
    stoppingCondition: Option[
      zio.aws.sagemaker.model.MonitoringStoppingCondition
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeModelQualityJobDefinitionResponse = {
    import DescribeModelQualityJobDefinitionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeModelQualityJobDefinitionResponse
      .builder()
      .jobDefinitionArn(
        MonitoringJobDefinitionArn.unwrap(jobDefinitionArn): java.lang.String
      )
      .jobDefinitionName(
        MonitoringJobDefinitionName.unwrap(jobDefinitionName): java.lang.String
      )
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .optionallyWith(
        modelQualityBaselineConfig.map(value => value.buildAwsValue())
      )(_.modelQualityBaselineConfig)
      .modelQualityAppSpecification(
        modelQualityAppSpecification.buildAwsValue()
      )
      .modelQualityJobInput(modelQualityJobInput.buildAwsValue())
      .modelQualityJobOutputConfig(modelQualityJobOutputConfig.buildAwsValue())
      .jobResources(jobResources.buildAwsValue())
      .optionallyWith(networkConfig.map(value => value.buildAwsValue()))(
        _.networkConfig
      )
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(stoppingCondition.map(value => value.buildAwsValue()))(
        _.stoppingCondition
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeModelQualityJobDefinitionResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeModelQualityJobDefinitionResponse
      .wrap(buildAwsValue())
}
object DescribeModelQualityJobDefinitionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeModelQualityJobDefinitionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.DescribeModelQualityJobDefinitionResponse =
      zio.aws.sagemaker.model.DescribeModelQualityJobDefinitionResponse(
        jobDefinitionArn,
        jobDefinitionName,
        creationTime,
        modelQualityBaselineConfig.map(value => value.asEditable),
        modelQualityAppSpecification.asEditable,
        modelQualityJobInput.asEditable,
        modelQualityJobOutputConfig.asEditable,
        jobResources.asEditable,
        networkConfig.map(value => value.asEditable),
        roleArn,
        stoppingCondition.map(value => value.asEditable)
      )
    def jobDefinitionArn: MonitoringJobDefinitionArn
    def jobDefinitionName: MonitoringJobDefinitionName
    def creationTime: Timestamp
    def modelQualityBaselineConfig
        : Option[zio.aws.sagemaker.model.ModelQualityBaselineConfig.ReadOnly]
    def modelQualityAppSpecification
        : zio.aws.sagemaker.model.ModelQualityAppSpecification.ReadOnly
    def modelQualityJobInput
        : zio.aws.sagemaker.model.ModelQualityJobInput.ReadOnly
    def modelQualityJobOutputConfig
        : zio.aws.sagemaker.model.MonitoringOutputConfig.ReadOnly
    def jobResources: zio.aws.sagemaker.model.MonitoringResources.ReadOnly
    def networkConfig
        : Option[zio.aws.sagemaker.model.MonitoringNetworkConfig.ReadOnly]
    def roleArn: RoleArn
    def stoppingCondition
        : Option[zio.aws.sagemaker.model.MonitoringStoppingCondition.ReadOnly]
    def getJobDefinitionArn: ZIO[Any, Nothing, MonitoringJobDefinitionArn] =
      ZIO.succeed(jobDefinitionArn)
    def getJobDefinitionName: ZIO[Any, Nothing, MonitoringJobDefinitionName] =
      ZIO.succeed(jobDefinitionName)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getModelQualityBaselineConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ModelQualityBaselineConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "modelQualityBaselineConfig",
      modelQualityBaselineConfig
    )
    def getModelQualityAppSpecification: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.ModelQualityAppSpecification.ReadOnly
    ] = ZIO.succeed(modelQualityAppSpecification)
    def getModelQualityJobInput: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.ModelQualityJobInput.ReadOnly
    ] = ZIO.succeed(modelQualityJobInput)
    def getModelQualityJobOutputConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.MonitoringOutputConfig.ReadOnly
    ] = ZIO.succeed(modelQualityJobOutputConfig)
    def getJobResources: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.MonitoringResources.ReadOnly
    ] = ZIO.succeed(jobResources)
    def getNetworkConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MonitoringNetworkConfig.ReadOnly
    ] = AwsError.unwrapOptionField("networkConfig", networkConfig)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getStoppingCondition: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MonitoringStoppingCondition.ReadOnly
    ] = AwsError.unwrapOptionField("stoppingCondition", stoppingCondition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeModelQualityJobDefinitionResponse
  ) extends zio.aws.sagemaker.model.DescribeModelQualityJobDefinitionResponse.ReadOnly {
    override val jobDefinitionArn: MonitoringJobDefinitionArn =
      zio.aws.sagemaker.model.primitives
        .MonitoringJobDefinitionArn(impl.jobDefinitionArn())
    override val jobDefinitionName: MonitoringJobDefinitionName =
      zio.aws.sagemaker.model.primitives
        .MonitoringJobDefinitionName(impl.jobDefinitionName())
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
    override val modelQualityBaselineConfig
        : Option[zio.aws.sagemaker.model.ModelQualityBaselineConfig.ReadOnly] =
      scala
        .Option(impl.modelQualityBaselineConfig())
        .map(value =>
          zio.aws.sagemaker.model.ModelQualityBaselineConfig.wrap(value)
        )
    override val modelQualityAppSpecification
        : zio.aws.sagemaker.model.ModelQualityAppSpecification.ReadOnly =
      zio.aws.sagemaker.model.ModelQualityAppSpecification
        .wrap(impl.modelQualityAppSpecification())
    override val modelQualityJobInput
        : zio.aws.sagemaker.model.ModelQualityJobInput.ReadOnly =
      zio.aws.sagemaker.model.ModelQualityJobInput
        .wrap(impl.modelQualityJobInput())
    override val modelQualityJobOutputConfig
        : zio.aws.sagemaker.model.MonitoringOutputConfig.ReadOnly =
      zio.aws.sagemaker.model.MonitoringOutputConfig
        .wrap(impl.modelQualityJobOutputConfig())
    override val jobResources
        : zio.aws.sagemaker.model.MonitoringResources.ReadOnly =
      zio.aws.sagemaker.model.MonitoringResources.wrap(impl.jobResources())
    override val networkConfig
        : Option[zio.aws.sagemaker.model.MonitoringNetworkConfig.ReadOnly] =
      scala
        .Option(impl.networkConfig())
        .map(value =>
          zio.aws.sagemaker.model.MonitoringNetworkConfig.wrap(value)
        )
    override val roleArn: RoleArn =
      zio.aws.sagemaker.model.primitives.RoleArn(impl.roleArn())
    override val stoppingCondition
        : Option[zio.aws.sagemaker.model.MonitoringStoppingCondition.ReadOnly] =
      scala
        .Option(impl.stoppingCondition())
        .map(value =>
          zio.aws.sagemaker.model.MonitoringStoppingCondition.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeModelQualityJobDefinitionResponse
  ): zio.aws.sagemaker.model.DescribeModelQualityJobDefinitionResponse.ReadOnly =
    new Wrapper(impl)
}
