package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{RoleArn, ModelName}
import scala.jdk.CollectionConverters._
final case class CreateModelRequest(
    modelName: ModelName,
    primaryContainer: Option[zio.aws.sagemaker.model.ContainerDefinition] =
      None,
    containers: Option[Iterable[zio.aws.sagemaker.model.ContainerDefinition]] =
      None,
    inferenceExecutionConfig: Option[
      zio.aws.sagemaker.model.InferenceExecutionConfig
    ] = None,
    executionRoleArn: RoleArn,
    tags: Option[Iterable[zio.aws.sagemaker.model.Tag]] = None,
    vpcConfig: Option[zio.aws.sagemaker.model.VpcConfig] = None,
    enableNetworkIsolation: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateModelRequest = {
    import CreateModelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateModelRequest
      .builder()
      .modelName(ModelName.unwrap(modelName): java.lang.String)
      .optionallyWith(primaryContainer.map(value => value.buildAwsValue()))(
        _.primaryContainer
      )
      .optionallyWith(
        containers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.containers)
      .optionallyWith(
        inferenceExecutionConfig.map(value => value.buildAwsValue())
      )(_.inferenceExecutionConfig)
      .executionRoleArn(RoleArn.unwrap(executionRoleArn): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(
        enableNetworkIsolation.map(value => value: java.lang.Boolean)
      )(_.enableNetworkIsolation)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateModelRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateModelRequest.wrap(buildAwsValue())
}
object CreateModelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateModelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateModelRequest =
      zio.aws.sagemaker.model.CreateModelRequest(
        modelName,
        primaryContainer.map(value => value.asEditable),
        containers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        inferenceExecutionConfig.map(value => value.asEditable),
        executionRoleArn,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpcConfig.map(value => value.asEditable),
        enableNetworkIsolation.map(value => value)
      )
    def modelName: ModelName
    def primaryContainer
        : Option[zio.aws.sagemaker.model.ContainerDefinition.ReadOnly]
    def containers
        : Option[List[zio.aws.sagemaker.model.ContainerDefinition.ReadOnly]]
    def inferenceExecutionConfig
        : Option[zio.aws.sagemaker.model.InferenceExecutionConfig.ReadOnly]
    def executionRoleArn: RoleArn
    def tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def vpcConfig: Option[zio.aws.sagemaker.model.VpcConfig.ReadOnly]
    def enableNetworkIsolation: Option[Boolean]
    def getModelName: ZIO[Any, Nothing, ModelName] = ZIO.succeed(modelName)
    def getPrimaryContainer: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ContainerDefinition.ReadOnly
    ] = AwsError.unwrapOptionField("primaryContainer", primaryContainer)
    def getContainers: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.ContainerDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField("containers", containers)
    def getInferenceExecutionConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.InferenceExecutionConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "inferenceExecutionConfig",
      inferenceExecutionConfig
    )
    def getExecutionRoleArn: ZIO[Any, Nothing, RoleArn] =
      ZIO.succeed(executionRoleArn)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.VpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getEnableNetworkIsolation: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("enableNetworkIsolation", enableNetworkIsolation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateModelRequest
  ) extends zio.aws.sagemaker.model.CreateModelRequest.ReadOnly {
    override val modelName: ModelName =
      zio.aws.sagemaker.model.primitives.ModelName(impl.modelName())
    override val primaryContainer
        : Option[zio.aws.sagemaker.model.ContainerDefinition.ReadOnly] = scala
      .Option(impl.primaryContainer())
      .map(value => zio.aws.sagemaker.model.ContainerDefinition.wrap(value))
    override val containers
        : Option[List[zio.aws.sagemaker.model.ContainerDefinition.ReadOnly]] =
      scala
        .Option(impl.containers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.ContainerDefinition.wrap(item)
          }.toList
        )
    override val inferenceExecutionConfig
        : Option[zio.aws.sagemaker.model.InferenceExecutionConfig.ReadOnly] =
      scala
        .Option(impl.inferenceExecutionConfig())
        .map(value =>
          zio.aws.sagemaker.model.InferenceExecutionConfig.wrap(value)
        )
    override val executionRoleArn: RoleArn =
      zio.aws.sagemaker.model.primitives.RoleArn(impl.executionRoleArn())
    override val tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
    override val vpcConfig: Option[zio.aws.sagemaker.model.VpcConfig.ReadOnly] =
      scala
        .Option(impl.vpcConfig())
        .map(value => zio.aws.sagemaker.model.VpcConfig.wrap(value))
    override val enableNetworkIsolation: Option[Boolean] =
      scala.Option(impl.enableNetworkIsolation()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateModelRequest
  ): zio.aws.sagemaker.model.CreateModelRequest.ReadOnly = new Wrapper(impl)
}
