package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.ExperimentArn
import scala.jdk.CollectionConverters._
final case class CreateExperimentResponse(
    experimentArn: Option[ExperimentArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateExperimentResponse = {
    import CreateExperimentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateExperimentResponse
      .builder()
      .optionallyWith(
        experimentArn.map(value =>
          ExperimentArn.unwrap(value): java.lang.String
        )
      )(_.experimentArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateExperimentResponse.ReadOnly =
    zio.aws.sagemaker.model.CreateExperimentResponse.wrap(buildAwsValue())
}
object CreateExperimentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateExperimentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateExperimentResponse =
      zio.aws.sagemaker.model
        .CreateExperimentResponse(experimentArn.map(value => value))
    def experimentArn: Option[ExperimentArn]
    def getExperimentArn: ZIO[Any, AwsError, ExperimentArn] =
      AwsError.unwrapOptionField("experimentArn", experimentArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateExperimentResponse
  ) extends zio.aws.sagemaker.model.CreateExperimentResponse.ReadOnly {
    override val experimentArn: Option[ExperimentArn] = scala
      .Option(impl.experimentArn())
      .map(value => zio.aws.sagemaker.model.primitives.ExperimentArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateExperimentResponse
  ): zio.aws.sagemaker.model.CreateExperimentResponse.ReadOnly = new Wrapper(
    impl
  )
}
