package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{ParameterValue, ParameterKey}
import scala.jdk.CollectionConverters._
final case class ContinuousParameterRange(
    name: ParameterKey,
    minValue: ParameterValue,
    maxValue: ParameterValue,
    scalingType: Option[zio.aws.sagemaker.model.HyperParameterScalingType] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ContinuousParameterRange = {
    import ContinuousParameterRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ContinuousParameterRange
      .builder()
      .name(ParameterKey.unwrap(name): java.lang.String)
      .minValue(ParameterValue.unwrap(minValue): java.lang.String)
      .maxValue(ParameterValue.unwrap(maxValue): java.lang.String)
      .optionallyWith(scalingType.map(value => value.unwrap))(_.scalingType)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ContinuousParameterRange.ReadOnly =
    zio.aws.sagemaker.model.ContinuousParameterRange.wrap(buildAwsValue())
}
object ContinuousParameterRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ContinuousParameterRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ContinuousParameterRange =
      zio.aws.sagemaker.model.ContinuousParameterRange(
        name,
        minValue,
        maxValue,
        scalingType.map(value => value)
      )
    def name: ParameterKey
    def minValue: ParameterValue
    def maxValue: ParameterValue
    def scalingType: Option[zio.aws.sagemaker.model.HyperParameterScalingType]
    def getName: ZIO[Any, Nothing, ParameterKey] = ZIO.succeed(name)
    def getMinValue: ZIO[Any, Nothing, ParameterValue] = ZIO.succeed(minValue)
    def getMaxValue: ZIO[Any, Nothing, ParameterValue] = ZIO.succeed(maxValue)
    def getScalingType: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.HyperParameterScalingType
    ] = AwsError.unwrapOptionField("scalingType", scalingType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ContinuousParameterRange
  ) extends zio.aws.sagemaker.model.ContinuousParameterRange.ReadOnly {
    override val name: ParameterKey =
      zio.aws.sagemaker.model.primitives.ParameterKey(impl.name())
    override val minValue: ParameterValue =
      zio.aws.sagemaker.model.primitives.ParameterValue(impl.minValue())
    override val maxValue: ParameterValue =
      zio.aws.sagemaker.model.primitives.ParameterValue(impl.maxValue())
    override val scalingType
        : Option[zio.aws.sagemaker.model.HyperParameterScalingType] = scala
      .Option(impl.scalingType())
      .map(value =>
        zio.aws.sagemaker.model.HyperParameterScalingType.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ContinuousParameterRange
  ): zio.aws.sagemaker.model.ContinuousParameterRange.ReadOnly = new Wrapper(
    impl
  )
}
