package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait CandidateStepType {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.CandidateStepType
}
object CandidateStepType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.CandidateStepType
  ): zio.aws.sagemaker.model.CandidateStepType = value match {
    case software.amazon.awssdk.services.sagemaker.model.CandidateStepType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.CandidateStepType.AWS_SAGE_MAKER_TRAINING_JOB =>
      val r = `AWS::SageMaker::TrainingJob`
      r
    case software.amazon.awssdk.services.sagemaker.model.CandidateStepType.AWS_SAGE_MAKER_TRANSFORM_JOB =>
      val r = `AWS::SageMaker::TransformJob`
      r
    case software.amazon.awssdk.services.sagemaker.model.CandidateStepType.AWS_SAGE_MAKER_PROCESSING_JOB =>
      val r = `AWS::SageMaker::ProcessingJob`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.CandidateStepType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.CandidateStepType =
      software.amazon.awssdk.services.sagemaker.model.CandidateStepType.UNKNOWN_TO_SDK_VERSION
  }
  case object `AWS::SageMaker::TrainingJob`
      extends zio.aws.sagemaker.model.CandidateStepType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.CandidateStepType =
      software.amazon.awssdk.services.sagemaker.model.CandidateStepType.AWS_SAGE_MAKER_TRAINING_JOB
  }
  case object `AWS::SageMaker::TransformJob`
      extends zio.aws.sagemaker.model.CandidateStepType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.CandidateStepType =
      software.amazon.awssdk.services.sagemaker.model.CandidateStepType.AWS_SAGE_MAKER_TRANSFORM_JOB
  }
  case object `AWS::SageMaker::ProcessingJob`
      extends zio.aws.sagemaker.model.CandidateStepType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.CandidateStepType =
      software.amazon.awssdk.services.sagemaker.model.CandidateStepType.AWS_SAGE_MAKER_PROCESSING_JOB
  }
}
