package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.String2048
import scala.jdk.CollectionConverters._
final case class ArtifactSource(
    sourceUri: String2048,
    sourceTypes: Option[Iterable[zio.aws.sagemaker.model.ArtifactSourceType]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ArtifactSource = {
    import ArtifactSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ArtifactSource
      .builder()
      .sourceUri(String2048.unwrap(sourceUri): java.lang.String)
      .optionallyWith(
        sourceTypes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sourceTypes)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ArtifactSource.ReadOnly =
    zio.aws.sagemaker.model.ArtifactSource.wrap(buildAwsValue())
}
object ArtifactSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ArtifactSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ArtifactSource =
      zio.aws.sagemaker.model.ArtifactSource(
        sourceUri,
        sourceTypes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def sourceUri: String2048
    def sourceTypes
        : Option[List[zio.aws.sagemaker.model.ArtifactSourceType.ReadOnly]]
    def getSourceUri: ZIO[Any, Nothing, String2048] = ZIO.succeed(sourceUri)
    def getSourceTypes: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.ArtifactSourceType.ReadOnly
    ]] = AwsError.unwrapOptionField("sourceTypes", sourceTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ArtifactSource
  ) extends zio.aws.sagemaker.model.ArtifactSource.ReadOnly {
    override val sourceUri: String2048 =
      zio.aws.sagemaker.model.primitives.String2048(impl.sourceUri())
    override val sourceTypes
        : Option[List[zio.aws.sagemaker.model.ArtifactSourceType.ReadOnly]] =
      scala
        .Option(impl.sourceTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.ArtifactSourceType.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ArtifactSource
  ): zio.aws.sagemaker.model.ArtifactSource.ReadOnly = new Wrapper(impl)
}
