package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  PipelineExecutionName,
  PipelineExecutionDescription,
  PipelineExecutionArn
}
import scala.jdk.CollectionConverters._
final case class UpdatePipelineExecutionRequest(
    pipelineExecutionArn: PipelineExecutionArn,
    pipelineExecutionDescription: Option[PipelineExecutionDescription] = None,
    pipelineExecutionDisplayName: Option[PipelineExecutionName] = None,
    parallelismConfiguration: Option[
      zio.aws.sagemaker.model.ParallelismConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdatePipelineExecutionRequest = {
    import UpdatePipelineExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdatePipelineExecutionRequest
      .builder()
      .pipelineExecutionArn(
        PipelineExecutionArn.unwrap(pipelineExecutionArn): java.lang.String
      )
      .optionallyWith(
        pipelineExecutionDescription.map(value =>
          PipelineExecutionDescription.unwrap(value): java.lang.String
        )
      )(_.pipelineExecutionDescription)
      .optionallyWith(
        pipelineExecutionDisplayName.map(value =>
          PipelineExecutionName.unwrap(value): java.lang.String
        )
      )(_.pipelineExecutionDisplayName)
      .optionallyWith(
        parallelismConfiguration.map(value => value.buildAwsValue())
      )(_.parallelismConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.UpdatePipelineExecutionRequest.ReadOnly =
    zio.aws.sagemaker.model.UpdatePipelineExecutionRequest.wrap(buildAwsValue())
}
object UpdatePipelineExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdatePipelineExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdatePipelineExecutionRequest =
      zio.aws.sagemaker.model.UpdatePipelineExecutionRequest(
        pipelineExecutionArn,
        pipelineExecutionDescription.map(value => value),
        pipelineExecutionDisplayName.map(value => value),
        parallelismConfiguration.map(value => value.asEditable)
      )
    def pipelineExecutionArn: PipelineExecutionArn
    def pipelineExecutionDescription: Option[PipelineExecutionDescription]
    def pipelineExecutionDisplayName: Option[PipelineExecutionName]
    def parallelismConfiguration
        : Option[zio.aws.sagemaker.model.ParallelismConfiguration.ReadOnly]
    def getPipelineExecutionArn: ZIO[Any, Nothing, PipelineExecutionArn] =
      ZIO.succeed(pipelineExecutionArn)
    def getPipelineExecutionDescription
        : ZIO[Any, AwsError, PipelineExecutionDescription] =
      AwsError.unwrapOptionField(
        "pipelineExecutionDescription",
        pipelineExecutionDescription
      )
    def getPipelineExecutionDisplayName
        : ZIO[Any, AwsError, PipelineExecutionName] =
      AwsError.unwrapOptionField(
        "pipelineExecutionDisplayName",
        pipelineExecutionDisplayName
      )
    def getParallelismConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ParallelismConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "parallelismConfiguration",
      parallelismConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdatePipelineExecutionRequest
  ) extends zio.aws.sagemaker.model.UpdatePipelineExecutionRequest.ReadOnly {
    override val pipelineExecutionArn: PipelineExecutionArn =
      zio.aws.sagemaker.model.primitives
        .PipelineExecutionArn(impl.pipelineExecutionArn())
    override val pipelineExecutionDescription
        : Option[PipelineExecutionDescription] = scala
      .Option(impl.pipelineExecutionDescription())
      .map(value =>
        zio.aws.sagemaker.model.primitives.PipelineExecutionDescription(value)
      )
    override val pipelineExecutionDisplayName: Option[PipelineExecutionName] =
      scala
        .Option(impl.pipelineExecutionDisplayName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.PipelineExecutionName(value)
        )
    override val parallelismConfiguration
        : Option[zio.aws.sagemaker.model.ParallelismConfiguration.ReadOnly] =
      scala
        .Option(impl.parallelismConfiguration())
        .map(value =>
          zio.aws.sagemaker.model.ParallelismConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdatePipelineExecutionRequest
  ): zio.aws.sagemaker.model.UpdatePipelineExecutionRequest.ReadOnly =
    new Wrapper(impl)
}
