package zio.aws.sagemaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  RoleArn,
  DisassociateNotebookInstanceAcceleratorTypes,
  NotebookInstanceVolumeSizeInGB,
  DisassociateAdditionalCodeRepositories,
  DisassociateNotebookInstanceLifecycleConfig,
  NotebookInstanceName,
  CodeRepositoryNameOrUrl,
  NotebookInstanceLifecycleConfigName,
  DisassociateDefaultCodeRepository
}
import scala.jdk.CollectionConverters._
final case class UpdateNotebookInstanceRequest(
    notebookInstanceName: NotebookInstanceName,
    instanceType: Option[zio.aws.sagemaker.model.InstanceType] = None,
    roleArn: Option[RoleArn] = None,
    lifecycleConfigName: Option[NotebookInstanceLifecycleConfigName] = None,
    disassociateLifecycleConfig: Option[
      DisassociateNotebookInstanceLifecycleConfig
    ] = None,
    volumeSizeInGB: Option[NotebookInstanceVolumeSizeInGB] = None,
    defaultCodeRepository: Option[CodeRepositoryNameOrUrl] = None,
    additionalCodeRepositories: Option[Iterable[CodeRepositoryNameOrUrl]] =
      None,
    acceleratorTypes: Option[
      Iterable[zio.aws.sagemaker.model.NotebookInstanceAcceleratorType]
    ] = None,
    disassociateAcceleratorTypes: Option[
      DisassociateNotebookInstanceAcceleratorTypes
    ] = None,
    disassociateDefaultCodeRepository: Option[
      DisassociateDefaultCodeRepository
    ] = None,
    disassociateAdditionalCodeRepositories: Option[
      DisassociateAdditionalCodeRepositories
    ] = None,
    rootAccess: Option[zio.aws.sagemaker.model.RootAccess] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateNotebookInstanceRequest = {
    import UpdateNotebookInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateNotebookInstanceRequest
      .builder()
      .notebookInstanceName(
        NotebookInstanceName.unwrap(notebookInstanceName): java.lang.String
      )
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        lifecycleConfigName.map(value =>
          NotebookInstanceLifecycleConfigName.unwrap(value): java.lang.String
        )
      )(_.lifecycleConfigName)
      .optionallyWith(
        disassociateLifecycleConfig.map(value =>
          DisassociateNotebookInstanceLifecycleConfig.unwrap(
            value
          ): java.lang.Boolean
        )
      )(_.disassociateLifecycleConfig)
      .optionallyWith(
        volumeSizeInGB.map(value =>
          NotebookInstanceVolumeSizeInGB.unwrap(value): Integer
        )
      )(_.volumeSizeInGB)
      .optionallyWith(
        defaultCodeRepository.map(value =>
          CodeRepositoryNameOrUrl.unwrap(value): java.lang.String
        )
      )(_.defaultCodeRepository)
      .optionallyWith(
        additionalCodeRepositories.map(value =>
          value.map { item =>
            CodeRepositoryNameOrUrl.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.additionalCodeRepositories)
      .optionallyWith(
        acceleratorTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.acceleratorTypesWithStrings)
      .optionallyWith(
        disassociateAcceleratorTypes.map(value =>
          DisassociateNotebookInstanceAcceleratorTypes.unwrap(
            value
          ): java.lang.Boolean
        )
      )(_.disassociateAcceleratorTypes)
      .optionallyWith(
        disassociateDefaultCodeRepository.map(value =>
          DisassociateDefaultCodeRepository.unwrap(value): java.lang.Boolean
        )
      )(_.disassociateDefaultCodeRepository)
      .optionallyWith(
        disassociateAdditionalCodeRepositories.map(value =>
          DisassociateAdditionalCodeRepositories.unwrap(
            value
          ): java.lang.Boolean
        )
      )(_.disassociateAdditionalCodeRepositories)
      .optionallyWith(rootAccess.map(value => value.unwrap))(_.rootAccess)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.UpdateNotebookInstanceRequest.ReadOnly =
    zio.aws.sagemaker.model.UpdateNotebookInstanceRequest.wrap(buildAwsValue())
}
object UpdateNotebookInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateNotebookInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateNotebookInstanceRequest =
      zio.aws.sagemaker.model.UpdateNotebookInstanceRequest(
        notebookInstanceName,
        instanceType.map(value => value),
        roleArn.map(value => value),
        lifecycleConfigName.map(value => value),
        disassociateLifecycleConfig.map(value => value),
        volumeSizeInGB.map(value => value),
        defaultCodeRepository.map(value => value),
        additionalCodeRepositories.map(value => value),
        acceleratorTypes.map(value => value),
        disassociateAcceleratorTypes.map(value => value),
        disassociateDefaultCodeRepository.map(value => value),
        disassociateAdditionalCodeRepositories.map(value => value),
        rootAccess.map(value => value)
      )
    def notebookInstanceName: NotebookInstanceName
    def instanceType: Option[zio.aws.sagemaker.model.InstanceType]
    def roleArn: Option[RoleArn]
    def lifecycleConfigName: Option[NotebookInstanceLifecycleConfigName]
    def disassociateLifecycleConfig
        : Option[DisassociateNotebookInstanceLifecycleConfig]
    def volumeSizeInGB: Option[NotebookInstanceVolumeSizeInGB]
    def defaultCodeRepository: Option[CodeRepositoryNameOrUrl]
    def additionalCodeRepositories: Option[List[CodeRepositoryNameOrUrl]]
    def acceleratorTypes
        : Option[List[zio.aws.sagemaker.model.NotebookInstanceAcceleratorType]]
    def disassociateAcceleratorTypes
        : Option[DisassociateNotebookInstanceAcceleratorTypes]
    def disassociateDefaultCodeRepository
        : Option[DisassociateDefaultCodeRepository]
    def disassociateAdditionalCodeRepositories
        : Option[DisassociateAdditionalCodeRepositories]
    def rootAccess: Option[zio.aws.sagemaker.model.RootAccess]
    def getNotebookInstanceName: ZIO[Any, Nothing, NotebookInstanceName] =
      ZIO.succeed(notebookInstanceName)
    def getInstanceType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getLifecycleConfigName
        : ZIO[Any, AwsError, NotebookInstanceLifecycleConfigName] =
      AwsError.unwrapOptionField("lifecycleConfigName", lifecycleConfigName)
    def getDisassociateLifecycleConfig
        : ZIO[Any, AwsError, DisassociateNotebookInstanceLifecycleConfig] =
      AwsError.unwrapOptionField(
        "disassociateLifecycleConfig",
        disassociateLifecycleConfig
      )
    def getVolumeSizeInGB: ZIO[Any, AwsError, NotebookInstanceVolumeSizeInGB] =
      AwsError.unwrapOptionField("volumeSizeInGB", volumeSizeInGB)
    def getDefaultCodeRepository: ZIO[Any, AwsError, CodeRepositoryNameOrUrl] =
      AwsError.unwrapOptionField("defaultCodeRepository", defaultCodeRepository)
    def getAdditionalCodeRepositories
        : ZIO[Any, AwsError, List[CodeRepositoryNameOrUrl]] =
      AwsError.unwrapOptionField(
        "additionalCodeRepositories",
        additionalCodeRepositories
      )
    def getAcceleratorTypes: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.NotebookInstanceAcceleratorType
    ]] = AwsError.unwrapOptionField("acceleratorTypes", acceleratorTypes)
    def getDisassociateAcceleratorTypes
        : ZIO[Any, AwsError, DisassociateNotebookInstanceAcceleratorTypes] =
      AwsError.unwrapOptionField(
        "disassociateAcceleratorTypes",
        disassociateAcceleratorTypes
      )
    def getDisassociateDefaultCodeRepository
        : ZIO[Any, AwsError, DisassociateDefaultCodeRepository] =
      AwsError.unwrapOptionField(
        "disassociateDefaultCodeRepository",
        disassociateDefaultCodeRepository
      )
    def getDisassociateAdditionalCodeRepositories
        : ZIO[Any, AwsError, DisassociateAdditionalCodeRepositories] =
      AwsError.unwrapOptionField(
        "disassociateAdditionalCodeRepositories",
        disassociateAdditionalCodeRepositories
      )
    def getRootAccess: ZIO[Any, AwsError, zio.aws.sagemaker.model.RootAccess] =
      AwsError.unwrapOptionField("rootAccess", rootAccess)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateNotebookInstanceRequest
  ) extends zio.aws.sagemaker.model.UpdateNotebookInstanceRequest.ReadOnly {
    override val notebookInstanceName: NotebookInstanceName =
      zio.aws.sagemaker.model.primitives
        .NotebookInstanceName(impl.notebookInstanceName())
    override val instanceType: Option[zio.aws.sagemaker.model.InstanceType] =
      scala
        .Option(impl.instanceType())
        .map(value => zio.aws.sagemaker.model.InstanceType.wrap(value))
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.sagemaker.model.primitives.RoleArn(value))
    override val lifecycleConfigName
        : Option[NotebookInstanceLifecycleConfigName] = scala
      .Option(impl.lifecycleConfigName())
      .map(value =>
        zio.aws.sagemaker.model.primitives
          .NotebookInstanceLifecycleConfigName(value)
      )
    override val disassociateLifecycleConfig
        : Option[DisassociateNotebookInstanceLifecycleConfig] = scala
      .Option(impl.disassociateLifecycleConfig())
      .map(value =>
        zio.aws.sagemaker.model.primitives
          .DisassociateNotebookInstanceLifecycleConfig(value)
      )
    override val volumeSizeInGB: Option[NotebookInstanceVolumeSizeInGB] = scala
      .Option(impl.volumeSizeInGB())
      .map(value =>
        zio.aws.sagemaker.model.primitives.NotebookInstanceVolumeSizeInGB(value)
      )
    override val defaultCodeRepository: Option[CodeRepositoryNameOrUrl] = scala
      .Option(impl.defaultCodeRepository())
      .map(value =>
        zio.aws.sagemaker.model.primitives.CodeRepositoryNameOrUrl(value)
      )
    override val additionalCodeRepositories
        : Option[List[CodeRepositoryNameOrUrl]] = scala
      .Option(impl.additionalCodeRepositories())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.primitives.CodeRepositoryNameOrUrl(item)
        }.toList
      )
    override val acceleratorTypes: Option[
      List[zio.aws.sagemaker.model.NotebookInstanceAcceleratorType]
    ] = scala
      .Option(impl.acceleratorTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.NotebookInstanceAcceleratorType.wrap(item)
        }.toList
      )
    override val disassociateAcceleratorTypes
        : Option[DisassociateNotebookInstanceAcceleratorTypes] = scala
      .Option(impl.disassociateAcceleratorTypes())
      .map(value =>
        zio.aws.sagemaker.model.primitives
          .DisassociateNotebookInstanceAcceleratorTypes(value)
      )
    override val disassociateDefaultCodeRepository
        : Option[DisassociateDefaultCodeRepository] = scala
      .Option(impl.disassociateDefaultCodeRepository())
      .map(value =>
        zio.aws.sagemaker.model.primitives
          .DisassociateDefaultCodeRepository(value)
      )
    override val disassociateAdditionalCodeRepositories
        : Option[DisassociateAdditionalCodeRepositories] = scala
      .Option(impl.disassociateAdditionalCodeRepositories())
      .map(value =>
        zio.aws.sagemaker.model.primitives
          .DisassociateAdditionalCodeRepositories(value)
      )
    override val rootAccess: Option[zio.aws.sagemaker.model.RootAccess] = scala
      .Option(impl.rootAccess())
      .map(value => zio.aws.sagemaker.model.RootAccess.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateNotebookInstanceRequest
  ): zio.aws.sagemaker.model.UpdateNotebookInstanceRequest.ReadOnly =
    new Wrapper(impl)
}
