package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  TrainingJobName,
  RoleArn,
  LabelingJobArn,
  HyperParameterTuningJobArn,
  Timestamp,
  FailureReason,
  TrainingEnvironmentKey,
  TrainingEnvironmentValue,
  TrainingJobArn,
  HyperParameterKey,
  BillableTimeInSeconds,
  TrainingTimeInSeconds,
  AutoMLJobArn,
  HyperParameterValue
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class TrainingJob(
    trainingJobName: Option[TrainingJobName] = None,
    trainingJobArn: Option[TrainingJobArn] = None,
    tuningJobArn: Option[HyperParameterTuningJobArn] = None,
    labelingJobArn: Option[LabelingJobArn] = None,
    autoMLJobArn: Option[AutoMLJobArn] = None,
    modelArtifacts: Option[zio.aws.sagemaker.model.ModelArtifacts] = None,
    trainingJobStatus: Option[zio.aws.sagemaker.model.TrainingJobStatus] = None,
    secondaryStatus: Option[zio.aws.sagemaker.model.SecondaryStatus] = None,
    failureReason: Option[FailureReason] = None,
    hyperParameters: Option[Map[HyperParameterKey, HyperParameterValue]] = None,
    algorithmSpecification: Option[
      zio.aws.sagemaker.model.AlgorithmSpecification
    ] = None,
    roleArn: Option[RoleArn] = None,
    inputDataConfig: Option[Iterable[zio.aws.sagemaker.model.Channel]] = None,
    outputDataConfig: Option[zio.aws.sagemaker.model.OutputDataConfig] = None,
    resourceConfig: Option[zio.aws.sagemaker.model.ResourceConfig] = None,
    vpcConfig: Option[zio.aws.sagemaker.model.VpcConfig] = None,
    stoppingCondition: Option[zio.aws.sagemaker.model.StoppingCondition] = None,
    creationTime: Option[Timestamp] = None,
    trainingStartTime: Option[Timestamp] = None,
    trainingEndTime: Option[Timestamp] = None,
    lastModifiedTime: Option[Timestamp] = None,
    secondaryStatusTransitions: Option[
      Iterable[zio.aws.sagemaker.model.SecondaryStatusTransition]
    ] = None,
    finalMetricDataList: Option[Iterable[zio.aws.sagemaker.model.MetricData]] =
      None,
    enableNetworkIsolation: Option[Boolean] = None,
    enableInterContainerTrafficEncryption: Option[Boolean] = None,
    enableManagedSpotTraining: Option[Boolean] = None,
    checkpointConfig: Option[zio.aws.sagemaker.model.CheckpointConfig] = None,
    trainingTimeInSeconds: Option[TrainingTimeInSeconds] = None,
    billableTimeInSeconds: Option[BillableTimeInSeconds] = None,
    debugHookConfig: Option[zio.aws.sagemaker.model.DebugHookConfig] = None,
    experimentConfig: Option[zio.aws.sagemaker.model.ExperimentConfig] = None,
    debugRuleConfigurations: Option[
      Iterable[zio.aws.sagemaker.model.DebugRuleConfiguration]
    ] = None,
    tensorBoardOutputConfig: Option[
      zio.aws.sagemaker.model.TensorBoardOutputConfig
    ] = None,
    debugRuleEvaluationStatuses: Option[
      Iterable[zio.aws.sagemaker.model.DebugRuleEvaluationStatus]
    ] = None,
    environment: Option[Map[TrainingEnvironmentKey, TrainingEnvironmentValue]] =
      None,
    retryStrategy: Option[zio.aws.sagemaker.model.RetryStrategy] = None,
    tags: Option[Iterable[zio.aws.sagemaker.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TrainingJob = {
    import TrainingJob.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TrainingJob
      .builder()
      .optionallyWith(
        trainingJobName.map(value =>
          TrainingJobName.unwrap(value): java.lang.String
        )
      )(_.trainingJobName)
      .optionallyWith(
        trainingJobArn.map(value =>
          TrainingJobArn.unwrap(value): java.lang.String
        )
      )(_.trainingJobArn)
      .optionallyWith(
        tuningJobArn.map(value =>
          HyperParameterTuningJobArn.unwrap(value): java.lang.String
        )
      )(_.tuningJobArn)
      .optionallyWith(
        labelingJobArn.map(value =>
          LabelingJobArn.unwrap(value): java.lang.String
        )
      )(_.labelingJobArn)
      .optionallyWith(
        autoMLJobArn.map(value => AutoMLJobArn.unwrap(value): java.lang.String)
      )(_.autoMLJobArn)
      .optionallyWith(modelArtifacts.map(value => value.buildAwsValue()))(
        _.modelArtifacts
      )
      .optionallyWith(trainingJobStatus.map(value => value.unwrap))(
        _.trainingJobStatus
      )
      .optionallyWith(secondaryStatus.map(value => value.unwrap))(
        _.secondaryStatus
      )
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        hyperParameters.map(value =>
          value
            .map({ case (key, value) =>
              (HyperParameterKey.unwrap(
                key
              ): java.lang.String) -> (HyperParameterValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.hyperParameters)
      .optionallyWith(
        algorithmSpecification.map(value => value.buildAwsValue())
      )(_.algorithmSpecification)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        inputDataConfig.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inputDataConfig)
      .optionallyWith(outputDataConfig.map(value => value.buildAwsValue()))(
        _.outputDataConfig
      )
      .optionallyWith(resourceConfig.map(value => value.buildAwsValue()))(
        _.resourceConfig
      )
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(stoppingCondition.map(value => value.buildAwsValue()))(
        _.stoppingCondition
      )
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        trainingStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.trainingStartTime)
      .optionallyWith(
        trainingEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.trainingEndTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        secondaryStatusTransitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.secondaryStatusTransitions)
      .optionallyWith(
        finalMetricDataList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.finalMetricDataList)
      .optionallyWith(
        enableNetworkIsolation.map(value => value: java.lang.Boolean)
      )(_.enableNetworkIsolation)
      .optionallyWith(
        enableInterContainerTrafficEncryption.map(value =>
          value: java.lang.Boolean
        )
      )(_.enableInterContainerTrafficEncryption)
      .optionallyWith(
        enableManagedSpotTraining.map(value => value: java.lang.Boolean)
      )(_.enableManagedSpotTraining)
      .optionallyWith(checkpointConfig.map(value => value.buildAwsValue()))(
        _.checkpointConfig
      )
      .optionallyWith(
        trainingTimeInSeconds.map(value =>
          TrainingTimeInSeconds.unwrap(value): Integer
        )
      )(_.trainingTimeInSeconds)
      .optionallyWith(
        billableTimeInSeconds.map(value =>
          BillableTimeInSeconds.unwrap(value): Integer
        )
      )(_.billableTimeInSeconds)
      .optionallyWith(debugHookConfig.map(value => value.buildAwsValue()))(
        _.debugHookConfig
      )
      .optionallyWith(experimentConfig.map(value => value.buildAwsValue()))(
        _.experimentConfig
      )
      .optionallyWith(
        debugRuleConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.debugRuleConfigurations)
      .optionallyWith(
        tensorBoardOutputConfig.map(value => value.buildAwsValue())
      )(_.tensorBoardOutputConfig)
      .optionallyWith(
        debugRuleEvaluationStatuses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.debugRuleEvaluationStatuses)
      .optionallyWith(
        environment.map(value =>
          value
            .map({ case (key, value) =>
              (TrainingEnvironmentKey.unwrap(
                key
              ): java.lang.String) -> (TrainingEnvironmentValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.environment)
      .optionallyWith(retryStrategy.map(value => value.buildAwsValue()))(
        _.retryStrategy
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.TrainingJob.ReadOnly =
    zio.aws.sagemaker.model.TrainingJob.wrap(buildAwsValue())
}
object TrainingJob {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TrainingJob
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TrainingJob =
      zio.aws.sagemaker.model.TrainingJob(
        trainingJobName.map(value => value),
        trainingJobArn.map(value => value),
        tuningJobArn.map(value => value),
        labelingJobArn.map(value => value),
        autoMLJobArn.map(value => value),
        modelArtifacts.map(value => value.asEditable),
        trainingJobStatus.map(value => value),
        secondaryStatus.map(value => value),
        failureReason.map(value => value),
        hyperParameters.map(value => value),
        algorithmSpecification.map(value => value.asEditable),
        roleArn.map(value => value),
        inputDataConfig.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        outputDataConfig.map(value => value.asEditable),
        resourceConfig.map(value => value.asEditable),
        vpcConfig.map(value => value.asEditable),
        stoppingCondition.map(value => value.asEditable),
        creationTime.map(value => value),
        trainingStartTime.map(value => value),
        trainingEndTime.map(value => value),
        lastModifiedTime.map(value => value),
        secondaryStatusTransitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        finalMetricDataList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        enableNetworkIsolation.map(value => value),
        enableInterContainerTrafficEncryption.map(value => value),
        enableManagedSpotTraining.map(value => value),
        checkpointConfig.map(value => value.asEditable),
        trainingTimeInSeconds.map(value => value),
        billableTimeInSeconds.map(value => value),
        debugHookConfig.map(value => value.asEditable),
        experimentConfig.map(value => value.asEditable),
        debugRuleConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tensorBoardOutputConfig.map(value => value.asEditable),
        debugRuleEvaluationStatuses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        environment.map(value => value),
        retryStrategy.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def trainingJobName: Option[TrainingJobName]
    def trainingJobArn: Option[TrainingJobArn]
    def tuningJobArn: Option[HyperParameterTuningJobArn]
    def labelingJobArn: Option[LabelingJobArn]
    def autoMLJobArn: Option[AutoMLJobArn]
    def modelArtifacts: Option[zio.aws.sagemaker.model.ModelArtifacts.ReadOnly]
    def trainingJobStatus: Option[zio.aws.sagemaker.model.TrainingJobStatus]
    def secondaryStatus: Option[zio.aws.sagemaker.model.SecondaryStatus]
    def failureReason: Option[FailureReason]
    def hyperParameters: Option[Map[HyperParameterKey, HyperParameterValue]]
    def algorithmSpecification
        : Option[zio.aws.sagemaker.model.AlgorithmSpecification.ReadOnly]
    def roleArn: Option[RoleArn]
    def inputDataConfig: Option[List[zio.aws.sagemaker.model.Channel.ReadOnly]]
    def outputDataConfig
        : Option[zio.aws.sagemaker.model.OutputDataConfig.ReadOnly]
    def resourceConfig: Option[zio.aws.sagemaker.model.ResourceConfig.ReadOnly]
    def vpcConfig: Option[zio.aws.sagemaker.model.VpcConfig.ReadOnly]
    def stoppingCondition
        : Option[zio.aws.sagemaker.model.StoppingCondition.ReadOnly]
    def creationTime: Option[Timestamp]
    def trainingStartTime: Option[Timestamp]
    def trainingEndTime: Option[Timestamp]
    def lastModifiedTime: Option[Timestamp]
    def secondaryStatusTransitions: Option[
      List[zio.aws.sagemaker.model.SecondaryStatusTransition.ReadOnly]
    ]
    def finalMetricDataList
        : Option[List[zio.aws.sagemaker.model.MetricData.ReadOnly]]
    def enableNetworkIsolation: Option[Boolean]
    def enableInterContainerTrafficEncryption: Option[Boolean]
    def enableManagedSpotTraining: Option[Boolean]
    def checkpointConfig
        : Option[zio.aws.sagemaker.model.CheckpointConfig.ReadOnly]
    def trainingTimeInSeconds: Option[TrainingTimeInSeconds]
    def billableTimeInSeconds: Option[BillableTimeInSeconds]
    def debugHookConfig
        : Option[zio.aws.sagemaker.model.DebugHookConfig.ReadOnly]
    def experimentConfig
        : Option[zio.aws.sagemaker.model.ExperimentConfig.ReadOnly]
    def debugRuleConfigurations
        : Option[List[zio.aws.sagemaker.model.DebugRuleConfiguration.ReadOnly]]
    def tensorBoardOutputConfig
        : Option[zio.aws.sagemaker.model.TensorBoardOutputConfig.ReadOnly]
    def debugRuleEvaluationStatuses: Option[
      List[zio.aws.sagemaker.model.DebugRuleEvaluationStatus.ReadOnly]
    ]
    def environment
        : Option[Map[TrainingEnvironmentKey, TrainingEnvironmentValue]]
    def retryStrategy: Option[zio.aws.sagemaker.model.RetryStrategy.ReadOnly]
    def tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def getTrainingJobName: ZIO[Any, AwsError, TrainingJobName] =
      AwsError.unwrapOptionField("trainingJobName", trainingJobName)
    def getTrainingJobArn: ZIO[Any, AwsError, TrainingJobArn] =
      AwsError.unwrapOptionField("trainingJobArn", trainingJobArn)
    def getTuningJobArn: ZIO[Any, AwsError, HyperParameterTuningJobArn] =
      AwsError.unwrapOptionField("tuningJobArn", tuningJobArn)
    def getLabelingJobArn: ZIO[Any, AwsError, LabelingJobArn] =
      AwsError.unwrapOptionField("labelingJobArn", labelingJobArn)
    def getAutoMLJobArn: ZIO[Any, AwsError, AutoMLJobArn] =
      AwsError.unwrapOptionField("autoMLJobArn", autoMLJobArn)
    def getModelArtifacts
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ModelArtifacts.ReadOnly] =
      AwsError.unwrapOptionField("modelArtifacts", modelArtifacts)
    def getTrainingJobStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.TrainingJobStatus] =
      AwsError.unwrapOptionField("trainingJobStatus", trainingJobStatus)
    def getSecondaryStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.SecondaryStatus] =
      AwsError.unwrapOptionField("secondaryStatus", secondaryStatus)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getHyperParameters
        : ZIO[Any, AwsError, Map[HyperParameterKey, HyperParameterValue]] =
      AwsError.unwrapOptionField("hyperParameters", hyperParameters)
    def getAlgorithmSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AlgorithmSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "algorithmSpecification",
      algorithmSpecification
    )
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getInputDataConfig
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Channel.ReadOnly]] =
      AwsError.unwrapOptionField("inputDataConfig", inputDataConfig)
    def getOutputDataConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.OutputDataConfig.ReadOnly
    ] = AwsError.unwrapOptionField("outputDataConfig", outputDataConfig)
    def getResourceConfig
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ResourceConfig.ReadOnly] =
      AwsError.unwrapOptionField("resourceConfig", resourceConfig)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.VpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getStoppingCondition: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.StoppingCondition.ReadOnly
    ] = AwsError.unwrapOptionField("stoppingCondition", stoppingCondition)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getTrainingStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("trainingStartTime", trainingStartTime)
    def getTrainingEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("trainingEndTime", trainingEndTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getSecondaryStatusTransitions: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.SecondaryStatusTransition.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "secondaryStatusTransitions",
      secondaryStatusTransitions
    )
    def getFinalMetricDataList: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.MetricData.ReadOnly
    ]] = AwsError.unwrapOptionField("finalMetricDataList", finalMetricDataList)
    def getEnableNetworkIsolation: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("enableNetworkIsolation", enableNetworkIsolation)
    def getEnableInterContainerTrafficEncryption: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "enableInterContainerTrafficEncryption",
        enableInterContainerTrafficEncryption
      )
    def getEnableManagedSpotTraining: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("enableManagedSpotTraining", enableManagedSpotTraining)
    def getCheckpointConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.CheckpointConfig.ReadOnly
    ] = AwsError.unwrapOptionField("checkpointConfig", checkpointConfig)
    def getTrainingTimeInSeconds: ZIO[Any, AwsError, TrainingTimeInSeconds] =
      AwsError.unwrapOptionField("trainingTimeInSeconds", trainingTimeInSeconds)
    def getBillableTimeInSeconds: ZIO[Any, AwsError, BillableTimeInSeconds] =
      AwsError.unwrapOptionField("billableTimeInSeconds", billableTimeInSeconds)
    def getDebugHookConfig
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.DebugHookConfig.ReadOnly] =
      AwsError.unwrapOptionField("debugHookConfig", debugHookConfig)
    def getExperimentConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ExperimentConfig.ReadOnly
    ] = AwsError.unwrapOptionField("experimentConfig", experimentConfig)
    def getDebugRuleConfigurations: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.DebugRuleConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "debugRuleConfigurations",
      debugRuleConfigurations
    )
    def getTensorBoardOutputConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.TensorBoardOutputConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "tensorBoardOutputConfig",
      tensorBoardOutputConfig
    )
    def getDebugRuleEvaluationStatuses: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.DebugRuleEvaluationStatus.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "debugRuleEvaluationStatuses",
      debugRuleEvaluationStatuses
    )
    def getEnvironment: ZIO[Any, AwsError, Map[
      TrainingEnvironmentKey,
      TrainingEnvironmentValue
    ]] = AwsError.unwrapOptionField("environment", environment)
    def getRetryStrategy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.RetryStrategy.ReadOnly] =
      AwsError.unwrapOptionField("retryStrategy", retryStrategy)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TrainingJob
  ) extends zio.aws.sagemaker.model.TrainingJob.ReadOnly {
    override val trainingJobName: Option[TrainingJobName] = scala
      .Option(impl.trainingJobName())
      .map(value => zio.aws.sagemaker.model.primitives.TrainingJobName(value))
    override val trainingJobArn: Option[TrainingJobArn] = scala
      .Option(impl.trainingJobArn())
      .map(value => zio.aws.sagemaker.model.primitives.TrainingJobArn(value))
    override val tuningJobArn: Option[HyperParameterTuningJobArn] = scala
      .Option(impl.tuningJobArn())
      .map(value =>
        zio.aws.sagemaker.model.primitives.HyperParameterTuningJobArn(value)
      )
    override val labelingJobArn: Option[LabelingJobArn] = scala
      .Option(impl.labelingJobArn())
      .map(value => zio.aws.sagemaker.model.primitives.LabelingJobArn(value))
    override val autoMLJobArn: Option[AutoMLJobArn] = scala
      .Option(impl.autoMLJobArn())
      .map(value => zio.aws.sagemaker.model.primitives.AutoMLJobArn(value))
    override val modelArtifacts
        : Option[zio.aws.sagemaker.model.ModelArtifacts.ReadOnly] = scala
      .Option(impl.modelArtifacts())
      .map(value => zio.aws.sagemaker.model.ModelArtifacts.wrap(value))
    override val trainingJobStatus
        : Option[zio.aws.sagemaker.model.TrainingJobStatus] = scala
      .Option(impl.trainingJobStatus())
      .map(value => zio.aws.sagemaker.model.TrainingJobStatus.wrap(value))
    override val secondaryStatus
        : Option[zio.aws.sagemaker.model.SecondaryStatus] = scala
      .Option(impl.secondaryStatus())
      .map(value => zio.aws.sagemaker.model.SecondaryStatus.wrap(value))
    override val failureReason: Option[FailureReason] = scala
      .Option(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
    override val hyperParameters
        : Option[Map[HyperParameterKey, HyperParameterValue]] = scala
      .Option(impl.hyperParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.sagemaker.model.primitives.HyperParameterKey(
              key
            ) -> zio.aws.sagemaker.model.primitives.HyperParameterValue(value)
          })
          .toMap
      )
    override val algorithmSpecification
        : Option[zio.aws.sagemaker.model.AlgorithmSpecification.ReadOnly] =
      scala
        .Option(impl.algorithmSpecification())
        .map(value =>
          zio.aws.sagemaker.model.AlgorithmSpecification.wrap(value)
        )
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.sagemaker.model.primitives.RoleArn(value))
    override val inputDataConfig
        : Option[List[zio.aws.sagemaker.model.Channel.ReadOnly]] = scala
      .Option(impl.inputDataConfig())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.Channel.wrap(item)
        }.toList
      )
    override val outputDataConfig
        : Option[zio.aws.sagemaker.model.OutputDataConfig.ReadOnly] = scala
      .Option(impl.outputDataConfig())
      .map(value => zio.aws.sagemaker.model.OutputDataConfig.wrap(value))
    override val resourceConfig
        : Option[zio.aws.sagemaker.model.ResourceConfig.ReadOnly] = scala
      .Option(impl.resourceConfig())
      .map(value => zio.aws.sagemaker.model.ResourceConfig.wrap(value))
    override val vpcConfig: Option[zio.aws.sagemaker.model.VpcConfig.ReadOnly] =
      scala
        .Option(impl.vpcConfig())
        .map(value => zio.aws.sagemaker.model.VpcConfig.wrap(value))
    override val stoppingCondition
        : Option[zio.aws.sagemaker.model.StoppingCondition.ReadOnly] = scala
      .Option(impl.stoppingCondition())
      .map(value => zio.aws.sagemaker.model.StoppingCondition.wrap(value))
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val trainingStartTime: Option[Timestamp] = scala
      .Option(impl.trainingStartTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val trainingEndTime: Option[Timestamp] = scala
      .Option(impl.trainingEndTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTime: Option[Timestamp] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val secondaryStatusTransitions: Option[
      List[zio.aws.sagemaker.model.SecondaryStatusTransition.ReadOnly]
    ] = scala
      .Option(impl.secondaryStatusTransitions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.SecondaryStatusTransition.wrap(item)
        }.toList
      )
    override val finalMetricDataList
        : Option[List[zio.aws.sagemaker.model.MetricData.ReadOnly]] = scala
      .Option(impl.finalMetricDataList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.MetricData.wrap(item)
        }.toList
      )
    override val enableNetworkIsolation: Option[Boolean] =
      scala.Option(impl.enableNetworkIsolation()).map(value => value: Boolean)
    override val enableInterContainerTrafficEncryption: Option[Boolean] = scala
      .Option(impl.enableInterContainerTrafficEncryption())
      .map(value => value: Boolean)
    override val enableManagedSpotTraining: Option[Boolean] = scala
      .Option(impl.enableManagedSpotTraining())
      .map(value => value: Boolean)
    override val checkpointConfig
        : Option[zio.aws.sagemaker.model.CheckpointConfig.ReadOnly] = scala
      .Option(impl.checkpointConfig())
      .map(value => zio.aws.sagemaker.model.CheckpointConfig.wrap(value))
    override val trainingTimeInSeconds: Option[TrainingTimeInSeconds] = scala
      .Option(impl.trainingTimeInSeconds())
      .map(value =>
        zio.aws.sagemaker.model.primitives.TrainingTimeInSeconds(value)
      )
    override val billableTimeInSeconds: Option[BillableTimeInSeconds] = scala
      .Option(impl.billableTimeInSeconds())
      .map(value =>
        zio.aws.sagemaker.model.primitives.BillableTimeInSeconds(value)
      )
    override val debugHookConfig
        : Option[zio.aws.sagemaker.model.DebugHookConfig.ReadOnly] = scala
      .Option(impl.debugHookConfig())
      .map(value => zio.aws.sagemaker.model.DebugHookConfig.wrap(value))
    override val experimentConfig
        : Option[zio.aws.sagemaker.model.ExperimentConfig.ReadOnly] = scala
      .Option(impl.experimentConfig())
      .map(value => zio.aws.sagemaker.model.ExperimentConfig.wrap(value))
    override val debugRuleConfigurations: Option[
      List[zio.aws.sagemaker.model.DebugRuleConfiguration.ReadOnly]
    ] = scala
      .Option(impl.debugRuleConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.DebugRuleConfiguration.wrap(item)
        }.toList
      )
    override val tensorBoardOutputConfig
        : Option[zio.aws.sagemaker.model.TensorBoardOutputConfig.ReadOnly] =
      scala
        .Option(impl.tensorBoardOutputConfig())
        .map(value =>
          zio.aws.sagemaker.model.TensorBoardOutputConfig.wrap(value)
        )
    override val debugRuleEvaluationStatuses: Option[
      List[zio.aws.sagemaker.model.DebugRuleEvaluationStatus.ReadOnly]
    ] = scala
      .Option(impl.debugRuleEvaluationStatuses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.DebugRuleEvaluationStatus.wrap(item)
        }.toList
      )
    override val environment
        : Option[Map[TrainingEnvironmentKey, TrainingEnvironmentValue]] = scala
      .Option(impl.environment())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.sagemaker.model.primitives
              .TrainingEnvironmentKey(key) -> zio.aws.sagemaker.model.primitives
              .TrainingEnvironmentValue(value)
          })
          .toMap
      )
    override val retryStrategy
        : Option[zio.aws.sagemaker.model.RetryStrategy.ReadOnly] = scala
      .Option(impl.retryStrategy())
      .map(value => zio.aws.sagemaker.model.RetryStrategy.wrap(value))
    override val tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TrainingJob
  ): zio.aws.sagemaker.model.TrainingJob.ReadOnly = new Wrapper(impl)
}
