package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  StepDisplayName,
  Timestamp,
  FailureReason,
  StepName,
  StepDescription,
  IntegerValue
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class PipelineExecutionStep(
    stepName: Option[StepName] = None,
    stepDisplayName: Option[StepDisplayName] = None,
    stepDescription: Option[StepDescription] = None,
    startTime: Option[Timestamp] = None,
    endTime: Option[Timestamp] = None,
    stepStatus: Option[zio.aws.sagemaker.model.StepStatus] = None,
    cacheHitResult: Option[zio.aws.sagemaker.model.CacheHitResult] = None,
    attemptCount: Option[IntegerValue] = None,
    failureReason: Option[FailureReason] = None,
    metadata: Option[zio.aws.sagemaker.model.PipelineExecutionStepMetadata] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.PipelineExecutionStep = {
    import PipelineExecutionStep.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.PipelineExecutionStep
      .builder()
      .optionallyWith(
        stepName.map(value => StepName.unwrap(value): java.lang.String)
      )(_.stepName)
      .optionallyWith(
        stepDisplayName.map(value =>
          StepDisplayName.unwrap(value): java.lang.String
        )
      )(_.stepDisplayName)
      .optionallyWith(
        stepDescription.map(value =>
          StepDescription.unwrap(value): java.lang.String
        )
      )(_.stepDescription)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(stepStatus.map(value => value.unwrap))(_.stepStatus)
      .optionallyWith(cacheHitResult.map(value => value.buildAwsValue()))(
        _.cacheHitResult
      )
      .optionallyWith(attemptCount.map(value => value: Integer))(_.attemptCount)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(metadata.map(value => value.buildAwsValue()))(_.metadata)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.PipelineExecutionStep.ReadOnly =
    zio.aws.sagemaker.model.PipelineExecutionStep.wrap(buildAwsValue())
}
object PipelineExecutionStep {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.PipelineExecutionStep
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.PipelineExecutionStep =
      zio.aws.sagemaker.model.PipelineExecutionStep(
        stepName.map(value => value),
        stepDisplayName.map(value => value),
        stepDescription.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        stepStatus.map(value => value),
        cacheHitResult.map(value => value.asEditable),
        attemptCount.map(value => value),
        failureReason.map(value => value),
        metadata.map(value => value.asEditable)
      )
    def stepName: Option[StepName]
    def stepDisplayName: Option[StepDisplayName]
    def stepDescription: Option[StepDescription]
    def startTime: Option[Timestamp]
    def endTime: Option[Timestamp]
    def stepStatus: Option[zio.aws.sagemaker.model.StepStatus]
    def cacheHitResult: Option[zio.aws.sagemaker.model.CacheHitResult.ReadOnly]
    def attemptCount: Option[IntegerValue]
    def failureReason: Option[FailureReason]
    def metadata
        : Option[zio.aws.sagemaker.model.PipelineExecutionStepMetadata.ReadOnly]
    def getStepName: ZIO[Any, AwsError, StepName] =
      AwsError.unwrapOptionField("stepName", stepName)
    def getStepDisplayName: ZIO[Any, AwsError, StepDisplayName] =
      AwsError.unwrapOptionField("stepDisplayName", stepDisplayName)
    def getStepDescription: ZIO[Any, AwsError, StepDescription] =
      AwsError.unwrapOptionField("stepDescription", stepDescription)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getStepStatus: ZIO[Any, AwsError, zio.aws.sagemaker.model.StepStatus] =
      AwsError.unwrapOptionField("stepStatus", stepStatus)
    def getCacheHitResult
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.CacheHitResult.ReadOnly] =
      AwsError.unwrapOptionField("cacheHitResult", cacheHitResult)
    def getAttemptCount: ZIO[Any, AwsError, IntegerValue] =
      AwsError.unwrapOptionField("attemptCount", attemptCount)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.PipelineExecutionStepMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("metadata", metadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.PipelineExecutionStep
  ) extends zio.aws.sagemaker.model.PipelineExecutionStep.ReadOnly {
    override val stepName: Option[StepName] = scala
      .Option(impl.stepName())
      .map(value => zio.aws.sagemaker.model.primitives.StepName(value))
    override val stepDisplayName: Option[StepDisplayName] = scala
      .Option(impl.stepDisplayName())
      .map(value => zio.aws.sagemaker.model.primitives.StepDisplayName(value))
    override val stepDescription: Option[StepDescription] = scala
      .Option(impl.stepDescription())
      .map(value => zio.aws.sagemaker.model.primitives.StepDescription(value))
    override val startTime: Option[Timestamp] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val endTime: Option[Timestamp] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val stepStatus: Option[zio.aws.sagemaker.model.StepStatus] = scala
      .Option(impl.stepStatus())
      .map(value => zio.aws.sagemaker.model.StepStatus.wrap(value))
    override val cacheHitResult
        : Option[zio.aws.sagemaker.model.CacheHitResult.ReadOnly] = scala
      .Option(impl.cacheHitResult())
      .map(value => zio.aws.sagemaker.model.CacheHitResult.wrap(value))
    override val attemptCount: Option[IntegerValue] =
      scala.Option(impl.attemptCount()).map(value => value: IntegerValue)
    override val failureReason: Option[FailureReason] = scala
      .Option(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
    override val metadata: Option[
      zio.aws.sagemaker.model.PipelineExecutionStepMetadata.ReadOnly
    ] = scala
      .Option(impl.metadata())
      .map(value =>
        zio.aws.sagemaker.model.PipelineExecutionStepMetadata.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.PipelineExecutionStep
  ): zio.aws.sagemaker.model.PipelineExecutionStep.ReadOnly = new Wrapper(impl)
}
