package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.EntityName
import scala.jdk.CollectionConverters._
final case class DeleteCodeRepositoryRequest(codeRepositoryName: EntityName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeleteCodeRepositoryRequest = {
    import DeleteCodeRepositoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeleteCodeRepositoryRequest
      .builder()
      .codeRepositoryName(
        EntityName.unwrap(codeRepositoryName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeleteCodeRepositoryRequest.ReadOnly =
    zio.aws.sagemaker.model.DeleteCodeRepositoryRequest.wrap(buildAwsValue())
}
object DeleteCodeRepositoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeleteCodeRepositoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeleteCodeRepositoryRequest =
      zio.aws.sagemaker.model.DeleteCodeRepositoryRequest(codeRepositoryName)
    def codeRepositoryName: EntityName
    def getCodeRepositoryName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(codeRepositoryName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteCodeRepositoryRequest
  ) extends zio.aws.sagemaker.model.DeleteCodeRepositoryRequest.ReadOnly {
    override val codeRepositoryName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.codeRepositoryName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteCodeRepositoryRequest
  ): zio.aws.sagemaker.model.DeleteCodeRepositoryRequest.ReadOnly = new Wrapper(
    impl
  )
}
