package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.ModelArn
import scala.jdk.CollectionConverters._
final case class CreateModelResponse(modelArn: ModelArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateModelResponse = {
    import CreateModelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateModelResponse
      .builder()
      .modelArn(ModelArn.unwrap(modelArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateModelResponse.ReadOnly =
    zio.aws.sagemaker.model.CreateModelResponse.wrap(buildAwsValue())
}
object CreateModelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateModelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateModelResponse =
      zio.aws.sagemaker.model.CreateModelResponse(modelArn)
    def modelArn: ModelArn
    def getModelArn: ZIO[Any, Nothing, ModelArn] = ZIO.succeed(modelArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateModelResponse
  ) extends zio.aws.sagemaker.model.CreateModelResponse.ReadOnly {
    override val modelArn: ModelArn =
      zio.aws.sagemaker.model.primitives.ModelArn(impl.modelArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateModelResponse
  ): zio.aws.sagemaker.model.CreateModelResponse.ReadOnly = new Wrapper(impl)
}
