package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.SnsTopicArn
import scala.jdk.CollectionConverters._
final case class AsyncInferenceNotificationConfig(
    successTopic: Option[SnsTopicArn] = None,
    errorTopic: Option[SnsTopicArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.AsyncInferenceNotificationConfig = {
    import AsyncInferenceNotificationConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.AsyncInferenceNotificationConfig
      .builder()
      .optionallyWith(
        successTopic.map(value => SnsTopicArn.unwrap(value): java.lang.String)
      )(_.successTopic)
      .optionallyWith(
        errorTopic.map(value => SnsTopicArn.unwrap(value): java.lang.String)
      )(_.errorTopic)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.AsyncInferenceNotificationConfig.ReadOnly =
    zio.aws.sagemaker.model.AsyncInferenceNotificationConfig
      .wrap(buildAwsValue())
}
object AsyncInferenceNotificationConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.AsyncInferenceNotificationConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.AsyncInferenceNotificationConfig =
      zio.aws.sagemaker.model.AsyncInferenceNotificationConfig(
        successTopic.map(value => value),
        errorTopic.map(value => value)
      )
    def successTopic: Option[SnsTopicArn]
    def errorTopic: Option[SnsTopicArn]
    def getSuccessTopic: ZIO[Any, AwsError, SnsTopicArn] =
      AwsError.unwrapOptionField("successTopic", successTopic)
    def getErrorTopic: ZIO[Any, AwsError, SnsTopicArn] =
      AwsError.unwrapOptionField("errorTopic", errorTopic)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.AsyncInferenceNotificationConfig
  ) extends zio.aws.sagemaker.model.AsyncInferenceNotificationConfig.ReadOnly {
    override val successTopic: Option[SnsTopicArn] = scala
      .Option(impl.successTopic())
      .map(value => zio.aws.sagemaker.model.primitives.SnsTopicArn(value))
    override val errorTopic: Option[SnsTopicArn] = scala
      .Option(impl.errorTopic())
      .map(value => zio.aws.sagemaker.model.primitives.SnsTopicArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.AsyncInferenceNotificationConfig
  ): zio.aws.sagemaker.model.AsyncInferenceNotificationConfig.ReadOnly =
    new Wrapper(impl)
}
