package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait AssociationEdgeType {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.AssociationEdgeType
}
object AssociationEdgeType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.AssociationEdgeType
  ): zio.aws.sagemaker.model.AssociationEdgeType = value match {
    case software.amazon.awssdk.services.sagemaker.model.AssociationEdgeType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.AssociationEdgeType.CONTRIBUTED_TO =>
      val r = ContributedTo
      r
    case software.amazon.awssdk.services.sagemaker.model.AssociationEdgeType.ASSOCIATED_WITH =>
      val r = AssociatedWith
      r
    case software.amazon.awssdk.services.sagemaker.model.AssociationEdgeType.DERIVED_FROM =>
      val r = DerivedFrom
      r
    case software.amazon.awssdk.services.sagemaker.model.AssociationEdgeType.PRODUCED =>
      val r = Produced
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.AssociationEdgeType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AssociationEdgeType =
      software.amazon.awssdk.services.sagemaker.model.AssociationEdgeType.UNKNOWN_TO_SDK_VERSION
  }
  case object ContributedTo
      extends zio.aws.sagemaker.model.AssociationEdgeType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AssociationEdgeType =
      software.amazon.awssdk.services.sagemaker.model.AssociationEdgeType.CONTRIBUTED_TO
  }
  case object AssociatedWith
      extends zio.aws.sagemaker.model.AssociationEdgeType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AssociationEdgeType =
      software.amazon.awssdk.services.sagemaker.model.AssociationEdgeType.ASSOCIATED_WITH
  }
  case object DerivedFrom extends zio.aws.sagemaker.model.AssociationEdgeType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AssociationEdgeType =
      software.amazon.awssdk.services.sagemaker.model.AssociationEdgeType.DERIVED_FROM
  }
  case object Produced extends zio.aws.sagemaker.model.AssociationEdgeType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AssociationEdgeType =
      software.amazon.awssdk.services.sagemaker.model.AssociationEdgeType.PRODUCED
  }
}
