package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.TrialArn
import scala.jdk.CollectionConverters._
final case class UpdateTrialResponse(trialArn: Option[TrialArn] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateTrialResponse = {
    import UpdateTrialResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateTrialResponse
      .builder()
      .optionallyWith(
        trialArn.map(value => TrialArn.unwrap(value): java.lang.String)
      )(_.trialArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UpdateTrialResponse.ReadOnly =
    zio.aws.sagemaker.model.UpdateTrialResponse.wrap(buildAwsValue())
}
object UpdateTrialResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateTrialResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateTrialResponse =
      zio.aws.sagemaker.model.UpdateTrialResponse(trialArn.map(value => value))
    def trialArn: Option[TrialArn]
    def getTrialArn: ZIO[Any, AwsError, TrialArn] =
      AwsError.unwrapOptionField("trialArn", trialArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateTrialResponse
  ) extends zio.aws.sagemaker.model.UpdateTrialResponse.ReadOnly {
    override val trialArn: Option[TrialArn] = scala
      .Option(impl.trialArn())
      .map(value => zio.aws.sagemaker.model.primitives.TrialArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateTrialResponse
  ): zio.aws.sagemaker.model.UpdateTrialResponse.ReadOnly = new Wrapper(impl)
}
