package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.NotebookInstanceLifecycleConfigName
import scala.jdk.CollectionConverters._
final case class UpdateNotebookInstanceLifecycleConfigRequest(
    notebookInstanceLifecycleConfigName: NotebookInstanceLifecycleConfigName,
    onCreate: Option[
      Iterable[zio.aws.sagemaker.model.NotebookInstanceLifecycleHook]
    ] = None,
    onStart: Option[
      Iterable[zio.aws.sagemaker.model.NotebookInstanceLifecycleHook]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateNotebookInstanceLifecycleConfigRequest = {
    import UpdateNotebookInstanceLifecycleConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateNotebookInstanceLifecycleConfigRequest
      .builder()
      .notebookInstanceLifecycleConfigName(
        NotebookInstanceLifecycleConfigName.unwrap(
          notebookInstanceLifecycleConfigName
        ): java.lang.String
      )
      .optionallyWith(
        onCreate.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.onCreate)
      .optionallyWith(
        onStart.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.onStart)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.UpdateNotebookInstanceLifecycleConfigRequest.ReadOnly =
    zio.aws.sagemaker.model.UpdateNotebookInstanceLifecycleConfigRequest
      .wrap(buildAwsValue())
}
object UpdateNotebookInstanceLifecycleConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateNotebookInstanceLifecycleConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.UpdateNotebookInstanceLifecycleConfigRequest =
      zio.aws.sagemaker.model.UpdateNotebookInstanceLifecycleConfigRequest(
        notebookInstanceLifecycleConfigName,
        onCreate.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        onStart.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def notebookInstanceLifecycleConfigName: NotebookInstanceLifecycleConfigName
    def onCreate: Option[
      List[zio.aws.sagemaker.model.NotebookInstanceLifecycleHook.ReadOnly]
    ]
    def onStart: Option[
      List[zio.aws.sagemaker.model.NotebookInstanceLifecycleHook.ReadOnly]
    ]
    def getNotebookInstanceLifecycleConfigName
        : ZIO[Any, Nothing, NotebookInstanceLifecycleConfigName] =
      ZIO.succeed(notebookInstanceLifecycleConfigName)
    def getOnCreate: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.NotebookInstanceLifecycleHook.ReadOnly
    ]] = AwsError.unwrapOptionField("onCreate", onCreate)
    def getOnStart: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.NotebookInstanceLifecycleHook.ReadOnly
    ]] = AwsError.unwrapOptionField("onStart", onStart)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateNotebookInstanceLifecycleConfigRequest
  ) extends zio.aws.sagemaker.model.UpdateNotebookInstanceLifecycleConfigRequest.ReadOnly {
    override val notebookInstanceLifecycleConfigName
        : NotebookInstanceLifecycleConfigName =
      zio.aws.sagemaker.model.primitives.NotebookInstanceLifecycleConfigName(
        impl.notebookInstanceLifecycleConfigName()
      )
    override val onCreate: Option[
      List[zio.aws.sagemaker.model.NotebookInstanceLifecycleHook.ReadOnly]
    ] = scala
      .Option(impl.onCreate())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.NotebookInstanceLifecycleHook.wrap(item)
        }.toList
      )
    override val onStart: Option[
      List[zio.aws.sagemaker.model.NotebookInstanceLifecycleHook.ReadOnly]
    ] = scala
      .Option(impl.onStart())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.NotebookInstanceLifecycleHook.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateNotebookInstanceLifecycleConfigRequest
  ): zio.aws.sagemaker.model.UpdateNotebookInstanceLifecycleConfigRequest.ReadOnly =
    new Wrapper(impl)
}
