package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.ImageArn
import scala.jdk.CollectionConverters._
final case class UpdateImageResponse(imageArn: Option[ImageArn] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateImageResponse = {
    import UpdateImageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateImageResponse
      .builder()
      .optionallyWith(
        imageArn.map(value => ImageArn.unwrap(value): java.lang.String)
      )(_.imageArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UpdateImageResponse.ReadOnly =
    zio.aws.sagemaker.model.UpdateImageResponse.wrap(buildAwsValue())
}
object UpdateImageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateImageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateImageResponse =
      zio.aws.sagemaker.model.UpdateImageResponse(imageArn.map(value => value))
    def imageArn: Option[ImageArn]
    def getImageArn: ZIO[Any, AwsError, ImageArn] =
      AwsError.unwrapOptionField("imageArn", imageArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateImageResponse
  ) extends zio.aws.sagemaker.model.UpdateImageResponse.ReadOnly {
    override val imageArn: Option[ImageArn] = scala
      .Option(impl.imageArn())
      .map(value => zio.aws.sagemaker.model.primitives.ImageArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateImageResponse
  ): zio.aws.sagemaker.model.UpdateImageResponse.ReadOnly = new Wrapper(impl)
}
