package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  StringParameterValue,
  ExperimentDescription,
  ExperimentEntityName
}
import scala.jdk.CollectionConverters._
final case class UpdateContextRequest(
    contextName: ExperimentEntityName,
    description: Option[ExperimentDescription] = None,
    properties: Option[Map[StringParameterValue, StringParameterValue]] = None,
    propertiesToRemove: Option[Iterable[StringParameterValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateContextRequest = {
    import UpdateContextRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateContextRequest
      .builder()
      .contextName(ExperimentEntityName.unwrap(contextName): java.lang.String)
      .optionallyWith(
        description.map(value =>
          ExperimentDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        properties.map(value =>
          value
            .map({ case (key, value) =>
              (StringParameterValue
                .unwrap(key): java.lang.String) -> (StringParameterValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.properties)
      .optionallyWith(
        propertiesToRemove.map(value =>
          value.map { item =>
            StringParameterValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.propertiesToRemove)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UpdateContextRequest.ReadOnly =
    zio.aws.sagemaker.model.UpdateContextRequest.wrap(buildAwsValue())
}
object UpdateContextRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateContextRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateContextRequest =
      zio.aws.sagemaker.model.UpdateContextRequest(
        contextName,
        description.map(value => value),
        properties.map(value => value),
        propertiesToRemove.map(value => value)
      )
    def contextName: ExperimentEntityName
    def description: Option[ExperimentDescription]
    def properties: Option[Map[StringParameterValue, StringParameterValue]]
    def propertiesToRemove: Option[List[StringParameterValue]]
    def getContextName: ZIO[Any, Nothing, ExperimentEntityName] =
      ZIO.succeed(contextName)
    def getDescription: ZIO[Any, AwsError, ExperimentDescription] =
      AwsError.unwrapOptionField("description", description)
    def getProperties
        : ZIO[Any, AwsError, Map[StringParameterValue, StringParameterValue]] =
      AwsError.unwrapOptionField("properties", properties)
    def getPropertiesToRemove: ZIO[Any, AwsError, List[StringParameterValue]] =
      AwsError.unwrapOptionField("propertiesToRemove", propertiesToRemove)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateContextRequest
  ) extends zio.aws.sagemaker.model.UpdateContextRequest.ReadOnly {
    override val contextName: ExperimentEntityName =
      zio.aws.sagemaker.model.primitives
        .ExperimentEntityName(impl.contextName())
    override val description: Option[ExperimentDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ExperimentDescription(value)
      )
    override val properties
        : Option[Map[StringParameterValue, StringParameterValue]] = scala
      .Option(impl.properties())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.sagemaker.model.primitives.StringParameterValue(
              key
            ) -> zio.aws.sagemaker.model.primitives.StringParameterValue(value)
          })
          .toMap
      )
    override val propertiesToRemove: Option[List[StringParameterValue]] = scala
      .Option(impl.propertiesToRemove())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.primitives.StringParameterValue(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateContextRequest
  ): zio.aws.sagemaker.model.UpdateContextRequest.ReadOnly = new Wrapper(impl)
}
