package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  StringParameterValue,
  ExperimentDescription,
  ExperimentEntityName
}
import scala.jdk.CollectionConverters._
final case class UpdateActionRequest(
    actionName: ExperimentEntityName,
    description: Option[ExperimentDescription] = None,
    status: Option[zio.aws.sagemaker.model.ActionStatus] = None,
    properties: Option[Map[StringParameterValue, StringParameterValue]] = None,
    propertiesToRemove: Option[Iterable[StringParameterValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateActionRequest = {
    import UpdateActionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateActionRequest
      .builder()
      .actionName(ExperimentEntityName.unwrap(actionName): java.lang.String)
      .optionallyWith(
        description.map(value =>
          ExperimentDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        properties.map(value =>
          value
            .map({ case (key, value) =>
              (StringParameterValue
                .unwrap(key): java.lang.String) -> (StringParameterValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.properties)
      .optionallyWith(
        propertiesToRemove.map(value =>
          value.map { item =>
            StringParameterValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.propertiesToRemove)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UpdateActionRequest.ReadOnly =
    zio.aws.sagemaker.model.UpdateActionRequest.wrap(buildAwsValue())
}
object UpdateActionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateActionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateActionRequest =
      zio.aws.sagemaker.model.UpdateActionRequest(
        actionName,
        description.map(value => value),
        status.map(value => value),
        properties.map(value => value),
        propertiesToRemove.map(value => value)
      )
    def actionName: ExperimentEntityName
    def description: Option[ExperimentDescription]
    def status: Option[zio.aws.sagemaker.model.ActionStatus]
    def properties: Option[Map[StringParameterValue, StringParameterValue]]
    def propertiesToRemove: Option[List[StringParameterValue]]
    def getActionName: ZIO[Any, Nothing, ExperimentEntityName] =
      ZIO.succeed(actionName)
    def getDescription: ZIO[Any, AwsError, ExperimentDescription] =
      AwsError.unwrapOptionField("description", description)
    def getStatus: ZIO[Any, AwsError, zio.aws.sagemaker.model.ActionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getProperties
        : ZIO[Any, AwsError, Map[StringParameterValue, StringParameterValue]] =
      AwsError.unwrapOptionField("properties", properties)
    def getPropertiesToRemove: ZIO[Any, AwsError, List[StringParameterValue]] =
      AwsError.unwrapOptionField("propertiesToRemove", propertiesToRemove)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateActionRequest
  ) extends zio.aws.sagemaker.model.UpdateActionRequest.ReadOnly {
    override val actionName: ExperimentEntityName =
      zio.aws.sagemaker.model.primitives.ExperimentEntityName(impl.actionName())
    override val description: Option[ExperimentDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ExperimentDescription(value)
      )
    override val status: Option[zio.aws.sagemaker.model.ActionStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.sagemaker.model.ActionStatus.wrap(value))
    override val properties
        : Option[Map[StringParameterValue, StringParameterValue]] = scala
      .Option(impl.properties())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.sagemaker.model.primitives.StringParameterValue(
              key
            ) -> zio.aws.sagemaker.model.primitives.StringParameterValue(value)
          })
          .toMap
      )
    override val propertiesToRemove: Option[List[StringParameterValue]] = scala
      .Option(impl.propertiesToRemove())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.primitives.StringParameterValue(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateActionRequest
  ): zio.aws.sagemaker.model.UpdateActionRequest.ReadOnly = new Wrapper(impl)
}
