package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.KmsKeyId
import scala.jdk.CollectionConverters._
final case class ProcessingOutputConfig(
    outputs: Iterable[zio.aws.sagemaker.model.ProcessingOutput],
    kmsKeyId: Option[KmsKeyId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ProcessingOutputConfig = {
    import ProcessingOutputConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ProcessingOutputConfig
      .builder()
      .outputs(outputs.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ProcessingOutputConfig.ReadOnly =
    zio.aws.sagemaker.model.ProcessingOutputConfig.wrap(buildAwsValue())
}
object ProcessingOutputConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ProcessingOutputConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ProcessingOutputConfig =
      zio.aws.sagemaker.model.ProcessingOutputConfig(
        outputs.map { item =>
          item.asEditable
        },
        kmsKeyId.map(value => value)
      )
    def outputs: List[zio.aws.sagemaker.model.ProcessingOutput.ReadOnly]
    def kmsKeyId: Option[KmsKeyId]
    def getOutputs: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.ProcessingOutput.ReadOnly
    ]] = ZIO.succeed(outputs)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ProcessingOutputConfig
  ) extends zio.aws.sagemaker.model.ProcessingOutputConfig.ReadOnly {
    override val outputs
        : List[zio.aws.sagemaker.model.ProcessingOutput.ReadOnly] = impl
      .outputs()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.ProcessingOutput.wrap(item)
      }
      .toList
    override val kmsKeyId: Option[KmsKeyId] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ProcessingOutputConfig
  ): zio.aws.sagemaker.model.ProcessingOutputConfig.ReadOnly = new Wrapper(impl)
}
