package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{VersionId, Key, BucketName}
import scala.jdk.CollectionConverters._
final case class PipelineDefinitionS3Location(
    bucket: BucketName,
    objectKey: Key,
    versionId: Option[VersionId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.PipelineDefinitionS3Location = {
    import PipelineDefinitionS3Location.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.PipelineDefinitionS3Location
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .objectKey(Key.unwrap(objectKey): java.lang.String)
      .optionallyWith(
        versionId.map(value => VersionId.unwrap(value): java.lang.String)
      )(_.versionId)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.PipelineDefinitionS3Location.ReadOnly =
    zio.aws.sagemaker.model.PipelineDefinitionS3Location.wrap(buildAwsValue())
}
object PipelineDefinitionS3Location {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.PipelineDefinitionS3Location
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.PipelineDefinitionS3Location =
      zio.aws.sagemaker.model.PipelineDefinitionS3Location(
        bucket,
        objectKey,
        versionId.map(value => value)
      )
    def bucket: BucketName
    def objectKey: Key
    def versionId: Option[VersionId]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getObjectKey: ZIO[Any, Nothing, Key] = ZIO.succeed(objectKey)
    def getVersionId: ZIO[Any, AwsError, VersionId] =
      AwsError.unwrapOptionField("versionId", versionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.PipelineDefinitionS3Location
  ) extends zio.aws.sagemaker.model.PipelineDefinitionS3Location.ReadOnly {
    override val bucket: BucketName =
      zio.aws.sagemaker.model.primitives.BucketName(impl.bucket())
    override val objectKey: Key =
      zio.aws.sagemaker.model.primitives.Key(impl.objectKey())
    override val versionId: Option[VersionId] = scala
      .Option(impl.versionId())
      .map(value => zio.aws.sagemaker.model.primitives.VersionId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.PipelineDefinitionS3Location
  ): zio.aws.sagemaker.model.PipelineDefinitionS3Location.ReadOnly =
    new Wrapper(impl)
}
