package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListMonitoringSchedulesResponse(
    monitoringScheduleSummaries: Iterable[
      zio.aws.sagemaker.model.MonitoringScheduleSummary
    ],
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListMonitoringSchedulesResponse = {
    import ListMonitoringSchedulesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListMonitoringSchedulesResponse
      .builder()
      .monitoringScheduleSummaries(monitoringScheduleSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListMonitoringSchedulesResponse.ReadOnly =
    zio.aws.sagemaker.model.ListMonitoringSchedulesResponse
      .wrap(buildAwsValue())
}
object ListMonitoringSchedulesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListMonitoringSchedulesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListMonitoringSchedulesResponse =
      zio.aws.sagemaker.model.ListMonitoringSchedulesResponse(
        monitoringScheduleSummaries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def monitoringScheduleSummaries
        : List[zio.aws.sagemaker.model.MonitoringScheduleSummary.ReadOnly]
    def nextToken: Option[NextToken]
    def getMonitoringScheduleSummaries: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.MonitoringScheduleSummary.ReadOnly
    ]] = ZIO.succeed(monitoringScheduleSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListMonitoringSchedulesResponse
  ) extends zio.aws.sagemaker.model.ListMonitoringSchedulesResponse.ReadOnly {
    override val monitoringScheduleSummaries
        : List[zio.aws.sagemaker.model.MonitoringScheduleSummary.ReadOnly] =
      impl
        .monitoringScheduleSummaries()
        .asScala
        .map { item =>
          zio.aws.sagemaker.model.MonitoringScheduleSummary.wrap(item)
        }
        .toList
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListMonitoringSchedulesResponse
  ): zio.aws.sagemaker.model.ListMonitoringSchedulesResponse.ReadOnly =
    new Wrapper(impl)
}
