package zio.aws.sagemaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  FlowDefinitionTaskKeyword,
  FlowDefinitionTaskTimeLimitInSeconds,
  FlowDefinitionTaskDescription,
  WorkteamArn,
  FlowDefinitionTaskCount,
  FlowDefinitionTaskTitle,
  HumanTaskUiArn,
  FlowDefinitionTaskAvailabilityLifetimeInSeconds
}
import scala.jdk.CollectionConverters._
final case class HumanLoopConfig(
    workteamArn: WorkteamArn,
    humanTaskUiArn: HumanTaskUiArn,
    taskTitle: FlowDefinitionTaskTitle,
    taskDescription: FlowDefinitionTaskDescription,
    taskCount: FlowDefinitionTaskCount,
    taskAvailabilityLifetimeInSeconds: Option[
      FlowDefinitionTaskAvailabilityLifetimeInSeconds
    ] = None,
    taskTimeLimitInSeconds: Option[FlowDefinitionTaskTimeLimitInSeconds] = None,
    taskKeywords: Option[Iterable[FlowDefinitionTaskKeyword]] = None,
    publicWorkforceTaskPrice: Option[
      zio.aws.sagemaker.model.PublicWorkforceTaskPrice
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.HumanLoopConfig = {
    import HumanLoopConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.HumanLoopConfig
      .builder()
      .workteamArn(WorkteamArn.unwrap(workteamArn): java.lang.String)
      .humanTaskUiArn(HumanTaskUiArn.unwrap(humanTaskUiArn): java.lang.String)
      .taskTitle(FlowDefinitionTaskTitle.unwrap(taskTitle): java.lang.String)
      .taskDescription(
        FlowDefinitionTaskDescription.unwrap(taskDescription): java.lang.String
      )
      .taskCount(FlowDefinitionTaskCount.unwrap(taskCount): Integer)
      .optionallyWith(
        taskAvailabilityLifetimeInSeconds.map(value =>
          FlowDefinitionTaskAvailabilityLifetimeInSeconds.unwrap(value): Integer
        )
      )(_.taskAvailabilityLifetimeInSeconds)
      .optionallyWith(
        taskTimeLimitInSeconds.map(value =>
          FlowDefinitionTaskTimeLimitInSeconds.unwrap(value): Integer
        )
      )(_.taskTimeLimitInSeconds)
      .optionallyWith(
        taskKeywords.map(value =>
          value.map { item =>
            FlowDefinitionTaskKeyword.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.taskKeywords)
      .optionallyWith(
        publicWorkforceTaskPrice.map(value => value.buildAwsValue())
      )(_.publicWorkforceTaskPrice)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.HumanLoopConfig.ReadOnly =
    zio.aws.sagemaker.model.HumanLoopConfig.wrap(buildAwsValue())
}
object HumanLoopConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.HumanLoopConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.HumanLoopConfig =
      zio.aws.sagemaker.model.HumanLoopConfig(
        workteamArn,
        humanTaskUiArn,
        taskTitle,
        taskDescription,
        taskCount,
        taskAvailabilityLifetimeInSeconds.map(value => value),
        taskTimeLimitInSeconds.map(value => value),
        taskKeywords.map(value => value),
        publicWorkforceTaskPrice.map(value => value.asEditable)
      )
    def workteamArn: WorkteamArn
    def humanTaskUiArn: HumanTaskUiArn
    def taskTitle: FlowDefinitionTaskTitle
    def taskDescription: FlowDefinitionTaskDescription
    def taskCount: FlowDefinitionTaskCount
    def taskAvailabilityLifetimeInSeconds
        : Option[FlowDefinitionTaskAvailabilityLifetimeInSeconds]
    def taskTimeLimitInSeconds: Option[FlowDefinitionTaskTimeLimitInSeconds]
    def taskKeywords: Option[List[FlowDefinitionTaskKeyword]]
    def publicWorkforceTaskPrice
        : Option[zio.aws.sagemaker.model.PublicWorkforceTaskPrice.ReadOnly]
    def getWorkteamArn: ZIO[Any, Nothing, WorkteamArn] =
      ZIO.succeed(workteamArn)
    def getHumanTaskUiArn: ZIO[Any, Nothing, HumanTaskUiArn] =
      ZIO.succeed(humanTaskUiArn)
    def getTaskTitle: ZIO[Any, Nothing, FlowDefinitionTaskTitle] =
      ZIO.succeed(taskTitle)
    def getTaskDescription: ZIO[Any, Nothing, FlowDefinitionTaskDescription] =
      ZIO.succeed(taskDescription)
    def getTaskCount: ZIO[Any, Nothing, FlowDefinitionTaskCount] =
      ZIO.succeed(taskCount)
    def getTaskAvailabilityLifetimeInSeconds
        : ZIO[Any, AwsError, FlowDefinitionTaskAvailabilityLifetimeInSeconds] =
      AwsError.unwrapOptionField(
        "taskAvailabilityLifetimeInSeconds",
        taskAvailabilityLifetimeInSeconds
      )
    def getTaskTimeLimitInSeconds
        : ZIO[Any, AwsError, FlowDefinitionTaskTimeLimitInSeconds] = AwsError
      .unwrapOptionField("taskTimeLimitInSeconds", taskTimeLimitInSeconds)
    def getTaskKeywords: ZIO[Any, AwsError, List[FlowDefinitionTaskKeyword]] =
      AwsError.unwrapOptionField("taskKeywords", taskKeywords)
    def getPublicWorkforceTaskPrice: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.PublicWorkforceTaskPrice.ReadOnly
    ] = AwsError.unwrapOptionField(
      "publicWorkforceTaskPrice",
      publicWorkforceTaskPrice
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.HumanLoopConfig
  ) extends zio.aws.sagemaker.model.HumanLoopConfig.ReadOnly {
    override val workteamArn: WorkteamArn =
      zio.aws.sagemaker.model.primitives.WorkteamArn(impl.workteamArn())
    override val humanTaskUiArn: HumanTaskUiArn =
      zio.aws.sagemaker.model.primitives.HumanTaskUiArn(impl.humanTaskUiArn())
    override val taskTitle: FlowDefinitionTaskTitle =
      zio.aws.sagemaker.model.primitives
        .FlowDefinitionTaskTitle(impl.taskTitle())
    override val taskDescription: FlowDefinitionTaskDescription =
      zio.aws.sagemaker.model.primitives
        .FlowDefinitionTaskDescription(impl.taskDescription())
    override val taskCount: FlowDefinitionTaskCount =
      zio.aws.sagemaker.model.primitives
        .FlowDefinitionTaskCount(impl.taskCount())
    override val taskAvailabilityLifetimeInSeconds
        : Option[FlowDefinitionTaskAvailabilityLifetimeInSeconds] = scala
      .Option(impl.taskAvailabilityLifetimeInSeconds())
      .map(value =>
        zio.aws.sagemaker.model.primitives
          .FlowDefinitionTaskAvailabilityLifetimeInSeconds(value)
      )
    override val taskTimeLimitInSeconds
        : Option[FlowDefinitionTaskTimeLimitInSeconds] = scala
      .Option(impl.taskTimeLimitInSeconds())
      .map(value =>
        zio.aws.sagemaker.model.primitives
          .FlowDefinitionTaskTimeLimitInSeconds(value)
      )
    override val taskKeywords: Option[List[FlowDefinitionTaskKeyword]] = scala
      .Option(impl.taskKeywords())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.primitives.FlowDefinitionTaskKeyword(item)
        }.toList
      )
    override val publicWorkforceTaskPrice
        : Option[zio.aws.sagemaker.model.PublicWorkforceTaskPrice.ReadOnly] =
      scala
        .Option(impl.publicWorkforceTaskPrice())
        .map(value =>
          zio.aws.sagemaker.model.PublicWorkforceTaskPrice.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.HumanLoopConfig
  ): zio.aws.sagemaker.model.HumanLoopConfig.ReadOnly = new Wrapper(impl)
}
