package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.WorkteamName
import scala.jdk.CollectionConverters._
final case class DescribeWorkteamRequest(workteamName: WorkteamName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeWorkteamRequest = {
    import DescribeWorkteamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeWorkteamRequest
      .builder()
      .workteamName(WorkteamName.unwrap(workteamName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeWorkteamRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeWorkteamRequest.wrap(buildAwsValue())
}
object DescribeWorkteamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeWorkteamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeWorkteamRequest =
      zio.aws.sagemaker.model.DescribeWorkteamRequest(workteamName)
    def workteamName: WorkteamName
    def getWorkteamName: ZIO[Any, Nothing, WorkteamName] =
      ZIO.succeed(workteamName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeWorkteamRequest
  ) extends zio.aws.sagemaker.model.DescribeWorkteamRequest.ReadOnly {
    override val workteamName: WorkteamName =
      zio.aws.sagemaker.model.primitives.WorkteamName(impl.workteamName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeWorkteamRequest
  ): zio.aws.sagemaker.model.DescribeWorkteamRequest.ReadOnly = new Wrapper(
    impl
  )
}
