package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.TrialComponentArn
import scala.jdk.CollectionConverters._
final case class DeleteTrialComponentResponse(
    trialComponentArn: Option[TrialComponentArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeleteTrialComponentResponse = {
    import DeleteTrialComponentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeleteTrialComponentResponse
      .builder()
      .optionallyWith(
        trialComponentArn.map(value =>
          TrialComponentArn.unwrap(value): java.lang.String
        )
      )(_.trialComponentArn)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DeleteTrialComponentResponse.ReadOnly =
    zio.aws.sagemaker.model.DeleteTrialComponentResponse.wrap(buildAwsValue())
}
object DeleteTrialComponentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeleteTrialComponentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeleteTrialComponentResponse =
      zio.aws.sagemaker.model
        .DeleteTrialComponentResponse(trialComponentArn.map(value => value))
    def trialComponentArn: Option[TrialComponentArn]
    def getTrialComponentArn: ZIO[Any, AwsError, TrialComponentArn] =
      AwsError.unwrapOptionField("trialComponentArn", trialComponentArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteTrialComponentResponse
  ) extends zio.aws.sagemaker.model.DeleteTrialComponentResponse.ReadOnly {
    override val trialComponentArn: Option[TrialComponentArn] = scala
      .Option(impl.trialComponentArn())
      .map(value => zio.aws.sagemaker.model.primitives.TrialComponentArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteTrialComponentResponse
  ): zio.aws.sagemaker.model.DeleteTrialComponentResponse.ReadOnly =
    new Wrapper(impl)
}
