package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  GenerateCandidateDefinitionsOnly,
  RoleArn,
  AutoMLJobName
}
import scala.jdk.CollectionConverters._
final case class CreateAutoMlJobRequest(
    autoMLJobName: AutoMLJobName,
    inputDataConfig: Iterable[zio.aws.sagemaker.model.AutoMLChannel],
    outputDataConfig: zio.aws.sagemaker.model.AutoMLOutputDataConfig,
    problemType: Option[zio.aws.sagemaker.model.ProblemType] = None,
    autoMLJobObjective: Option[zio.aws.sagemaker.model.AutoMLJobObjective] =
      None,
    autoMLJobConfig: Option[zio.aws.sagemaker.model.AutoMLJobConfig] = None,
    roleArn: RoleArn,
    generateCandidateDefinitionsOnly: Option[GenerateCandidateDefinitionsOnly] =
      None,
    tags: Option[Iterable[zio.aws.sagemaker.model.Tag]] = None,
    modelDeployConfig: Option[zio.aws.sagemaker.model.ModelDeployConfig] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateAutoMlJobRequest = {
    import CreateAutoMlJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateAutoMlJobRequest
      .builder()
      .autoMLJobName(AutoMLJobName.unwrap(autoMLJobName): java.lang.String)
      .inputDataConfig(inputDataConfig.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .outputDataConfig(outputDataConfig.buildAwsValue())
      .optionallyWith(problemType.map(value => value.unwrap))(_.problemType)
      .optionallyWith(autoMLJobObjective.map(value => value.buildAwsValue()))(
        _.autoMLJobObjective
      )
      .optionallyWith(autoMLJobConfig.map(value => value.buildAwsValue()))(
        _.autoMLJobConfig
      )
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        generateCandidateDefinitionsOnly.map(value =>
          GenerateCandidateDefinitionsOnly.unwrap(value): java.lang.Boolean
        )
      )(_.generateCandidateDefinitionsOnly)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(modelDeployConfig.map(value => value.buildAwsValue()))(
        _.modelDeployConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateAutoMlJobRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateAutoMlJobRequest.wrap(buildAwsValue())
}
object CreateAutoMlJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateAutoMlJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateAutoMlJobRequest =
      zio.aws.sagemaker.model.CreateAutoMlJobRequest(
        autoMLJobName,
        inputDataConfig.map { item =>
          item.asEditable
        },
        outputDataConfig.asEditable,
        problemType.map(value => value),
        autoMLJobObjective.map(value => value.asEditable),
        autoMLJobConfig.map(value => value.asEditable),
        roleArn,
        generateCandidateDefinitionsOnly.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        modelDeployConfig.map(value => value.asEditable)
      )
    def autoMLJobName: AutoMLJobName
    def inputDataConfig: List[zio.aws.sagemaker.model.AutoMLChannel.ReadOnly]
    def outputDataConfig
        : zio.aws.sagemaker.model.AutoMLOutputDataConfig.ReadOnly
    def problemType: Option[zio.aws.sagemaker.model.ProblemType]
    def autoMLJobObjective
        : Option[zio.aws.sagemaker.model.AutoMLJobObjective.ReadOnly]
    def autoMLJobConfig
        : Option[zio.aws.sagemaker.model.AutoMLJobConfig.ReadOnly]
    def roleArn: RoleArn
    def generateCandidateDefinitionsOnly
        : Option[GenerateCandidateDefinitionsOnly]
    def tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def modelDeployConfig
        : Option[zio.aws.sagemaker.model.ModelDeployConfig.ReadOnly]
    def getAutoMLJobName: ZIO[Any, Nothing, AutoMLJobName] =
      ZIO.succeed(autoMLJobName)
    def getInputDataConfig: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.AutoMLChannel.ReadOnly
    ]] = ZIO.succeed(inputDataConfig)
    def getOutputDataConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.AutoMLOutputDataConfig.ReadOnly
    ] = ZIO.succeed(outputDataConfig)
    def getProblemType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ProblemType] =
      AwsError.unwrapOptionField("problemType", problemType)
    def getAutoMLJobObjective: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AutoMLJobObjective.ReadOnly
    ] = AwsError.unwrapOptionField("autoMLJobObjective", autoMLJobObjective)
    def getAutoMLJobConfig
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.AutoMLJobConfig.ReadOnly] =
      AwsError.unwrapOptionField("autoMLJobConfig", autoMLJobConfig)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getGenerateCandidateDefinitionsOnly
        : ZIO[Any, AwsError, GenerateCandidateDefinitionsOnly] =
      AwsError.unwrapOptionField(
        "generateCandidateDefinitionsOnly",
        generateCandidateDefinitionsOnly
      )
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getModelDeployConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ModelDeployConfig.ReadOnly
    ] = AwsError.unwrapOptionField("modelDeployConfig", modelDeployConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateAutoMlJobRequest
  ) extends zio.aws.sagemaker.model.CreateAutoMlJobRequest.ReadOnly {
    override val autoMLJobName: AutoMLJobName =
      zio.aws.sagemaker.model.primitives.AutoMLJobName(impl.autoMLJobName())
    override val inputDataConfig
        : List[zio.aws.sagemaker.model.AutoMLChannel.ReadOnly] = impl
      .inputDataConfig()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.AutoMLChannel.wrap(item)
      }
      .toList
    override val outputDataConfig
        : zio.aws.sagemaker.model.AutoMLOutputDataConfig.ReadOnly =
      zio.aws.sagemaker.model.AutoMLOutputDataConfig
        .wrap(impl.outputDataConfig())
    override val problemType: Option[zio.aws.sagemaker.model.ProblemType] =
      scala
        .Option(impl.problemType())
        .map(value => zio.aws.sagemaker.model.ProblemType.wrap(value))
    override val autoMLJobObjective
        : Option[zio.aws.sagemaker.model.AutoMLJobObjective.ReadOnly] = scala
      .Option(impl.autoMLJobObjective())
      .map(value => zio.aws.sagemaker.model.AutoMLJobObjective.wrap(value))
    override val autoMLJobConfig
        : Option[zio.aws.sagemaker.model.AutoMLJobConfig.ReadOnly] = scala
      .Option(impl.autoMLJobConfig())
      .map(value => zio.aws.sagemaker.model.AutoMLJobConfig.wrap(value))
    override val roleArn: RoleArn =
      zio.aws.sagemaker.model.primitives.RoleArn(impl.roleArn())
    override val generateCandidateDefinitionsOnly
        : Option[GenerateCandidateDefinitionsOnly] = scala
      .Option(impl.generateCandidateDefinitionsOnly())
      .map(value =>
        zio.aws.sagemaker.model.primitives
          .GenerateCandidateDefinitionsOnly(value)
      )
    override val tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
    override val modelDeployConfig
        : Option[zio.aws.sagemaker.model.ModelDeployConfig.ReadOnly] = scala
      .Option(impl.modelDeployConfig())
      .map(value => zio.aws.sagemaker.model.ModelDeployConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateAutoMlJobRequest
  ): zio.aws.sagemaker.model.CreateAutoMlJobRequest.ReadOnly = new Wrapper(impl)
}
