package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.ParameterValue
import scala.jdk.CollectionConverters._
final case class CategoricalParameterRangeSpecification(
    values: Iterable[ParameterValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CategoricalParameterRangeSpecification = {
    import CategoricalParameterRangeSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CategoricalParameterRangeSpecification
      .builder()
      .values(values.map { item =>
        ParameterValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.CategoricalParameterRangeSpecification.ReadOnly =
    zio.aws.sagemaker.model.CategoricalParameterRangeSpecification
      .wrap(buildAwsValue())
}
object CategoricalParameterRangeSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CategoricalParameterRangeSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.CategoricalParameterRangeSpecification =
      zio.aws.sagemaker.model.CategoricalParameterRangeSpecification(values)
    def values: List[ParameterValue]
    def getValues: ZIO[Any, Nothing, List[ParameterValue]] = ZIO.succeed(values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CategoricalParameterRangeSpecification
  ) extends zio.aws.sagemaker.model.CategoricalParameterRangeSpecification.ReadOnly {
    override val values: List[ParameterValue] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.primitives.ParameterValue(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CategoricalParameterRangeSpecification
  ): zio.aws.sagemaker.model.CategoricalParameterRangeSpecification.ReadOnly =
    new Wrapper(impl)
}
