package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  AutoMLFailureReason,
  Timestamp,
  AutoMLJobArn,
  AutoMLJobName
}
import scala.jdk.CollectionConverters._
final case class AutoMLJobSummary(
    autoMLJobName: AutoMLJobName,
    autoMLJobArn: AutoMLJobArn,
    autoMLJobStatus: zio.aws.sagemaker.model.AutoMLJobStatus,
    autoMLJobSecondaryStatus: zio.aws.sagemaker.model.AutoMLJobSecondaryStatus,
    creationTime: Timestamp,
    endTime: Option[Timestamp] = None,
    lastModifiedTime: Timestamp,
    failureReason: Option[AutoMLFailureReason] = None,
    partialFailureReasons: Option[
      Iterable[zio.aws.sagemaker.model.AutoMLPartialFailureReason]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.AutoMLJobSummary = {
    import AutoMLJobSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.AutoMLJobSummary
      .builder()
      .autoMLJobName(AutoMLJobName.unwrap(autoMLJobName): java.lang.String)
      .autoMLJobArn(AutoMLJobArn.unwrap(autoMLJobArn): java.lang.String)
      .autoMLJobStatus(autoMLJobStatus.unwrap)
      .autoMLJobSecondaryStatus(autoMLJobSecondaryStatus.unwrap)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .lastModifiedTime(Timestamp.unwrap(lastModifiedTime): Instant)
      .optionallyWith(
        failureReason.map(value =>
          AutoMLFailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        partialFailureReasons.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.partialFailureReasons)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.AutoMLJobSummary.ReadOnly =
    zio.aws.sagemaker.model.AutoMLJobSummary.wrap(buildAwsValue())
}
object AutoMLJobSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.AutoMLJobSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.AutoMLJobSummary =
      zio.aws.sagemaker.model.AutoMLJobSummary(
        autoMLJobName,
        autoMLJobArn,
        autoMLJobStatus,
        autoMLJobSecondaryStatus,
        creationTime,
        endTime.map(value => value),
        lastModifiedTime,
        failureReason.map(value => value),
        partialFailureReasons.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def autoMLJobName: AutoMLJobName
    def autoMLJobArn: AutoMLJobArn
    def autoMLJobStatus: zio.aws.sagemaker.model.AutoMLJobStatus
    def autoMLJobSecondaryStatus
        : zio.aws.sagemaker.model.AutoMLJobSecondaryStatus
    def creationTime: Timestamp
    def endTime: Option[Timestamp]
    def lastModifiedTime: Timestamp
    def failureReason: Option[AutoMLFailureReason]
    def partialFailureReasons: Option[
      List[zio.aws.sagemaker.model.AutoMLPartialFailureReason.ReadOnly]
    ]
    def getAutoMLJobName: ZIO[Any, Nothing, AutoMLJobName] =
      ZIO.succeed(autoMLJobName)
    def getAutoMLJobArn: ZIO[Any, Nothing, AutoMLJobArn] =
      ZIO.succeed(autoMLJobArn)
    def getAutoMLJobStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.AutoMLJobStatus] =
      ZIO.succeed(autoMLJobStatus)
    def getAutoMLJobSecondaryStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.AutoMLJobSecondaryStatus] =
      ZIO.succeed(autoMLJobSecondaryStatus)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getLastModifiedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedTime)
    def getFailureReason: ZIO[Any, AwsError, AutoMLFailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getPartialFailureReasons: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.AutoMLPartialFailureReason.ReadOnly
    ]] =
      AwsError.unwrapOptionField("partialFailureReasons", partialFailureReasons)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoMLJobSummary
  ) extends zio.aws.sagemaker.model.AutoMLJobSummary.ReadOnly {
    override val autoMLJobName: AutoMLJobName =
      zio.aws.sagemaker.model.primitives.AutoMLJobName(impl.autoMLJobName())
    override val autoMLJobArn: AutoMLJobArn =
      zio.aws.sagemaker.model.primitives.AutoMLJobArn(impl.autoMLJobArn())
    override val autoMLJobStatus: zio.aws.sagemaker.model.AutoMLJobStatus =
      zio.aws.sagemaker.model.AutoMLJobStatus.wrap(impl.autoMLJobStatus())
    override val autoMLJobSecondaryStatus
        : zio.aws.sagemaker.model.AutoMLJobSecondaryStatus =
      zio.aws.sagemaker.model.AutoMLJobSecondaryStatus
        .wrap(impl.autoMLJobSecondaryStatus())
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
    override val endTime: Option[Timestamp] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.lastModifiedTime())
    override val failureReason: Option[AutoMLFailureReason] = scala
      .Option(impl.failureReason())
      .map(value =>
        zio.aws.sagemaker.model.primitives.AutoMLFailureReason(value)
      )
    override val partialFailureReasons: Option[
      List[zio.aws.sagemaker.model.AutoMLPartialFailureReason.ReadOnly]
    ] = scala
      .Option(impl.partialFailureReasons())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.AutoMLPartialFailureReason.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoMLJobSummary
  ): zio.aws.sagemaker.model.AutoMLJobSummary.ReadOnly = new Wrapper(impl)
}
