package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AsyncInferenceConfig(
    clientConfig: Option[zio.aws.sagemaker.model.AsyncInferenceClientConfig] =
      None,
    outputConfig: zio.aws.sagemaker.model.AsyncInferenceOutputConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.AsyncInferenceConfig = {
    import AsyncInferenceConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.AsyncInferenceConfig
      .builder()
      .optionallyWith(clientConfig.map(value => value.buildAwsValue()))(
        _.clientConfig
      )
      .outputConfig(outputConfig.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.AsyncInferenceConfig.ReadOnly =
    zio.aws.sagemaker.model.AsyncInferenceConfig.wrap(buildAwsValue())
}
object AsyncInferenceConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.AsyncInferenceConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.AsyncInferenceConfig =
      zio.aws.sagemaker.model.AsyncInferenceConfig(
        clientConfig.map(value => value.asEditable),
        outputConfig.asEditable
      )
    def clientConfig
        : Option[zio.aws.sagemaker.model.AsyncInferenceClientConfig.ReadOnly]
    def outputConfig
        : zio.aws.sagemaker.model.AsyncInferenceOutputConfig.ReadOnly
    def getClientConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AsyncInferenceClientConfig.ReadOnly
    ] = AwsError.unwrapOptionField("clientConfig", clientConfig)
    def getOutputConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.AsyncInferenceOutputConfig.ReadOnly
    ] = ZIO.succeed(outputConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.AsyncInferenceConfig
  ) extends zio.aws.sagemaker.model.AsyncInferenceConfig.ReadOnly {
    override val clientConfig
        : Option[zio.aws.sagemaker.model.AsyncInferenceClientConfig.ReadOnly] =
      scala
        .Option(impl.clientConfig())
        .map(value =>
          zio.aws.sagemaker.model.AsyncInferenceClientConfig.wrap(value)
        )
    override val outputConfig
        : zio.aws.sagemaker.model.AsyncInferenceOutputConfig.ReadOnly =
      zio.aws.sagemaker.model.AsyncInferenceOutputConfig
        .wrap(impl.outputConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.AsyncInferenceConfig
  ): zio.aws.sagemaker.model.AsyncInferenceConfig.ReadOnly = new Wrapper(impl)
}
